/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestFloatColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.any.FloatAnyAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatAnyAggregationTest
extends InitializedNullHandlingTest {
    private FloatAnyAggregatorFactory floatAnyAggFactory;
    private FloatAnyAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestFloatColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private float[] floats = new float[]{1.1897f, 0.001f, 86.23f, 166.228f};
    private Float[] objects = new Float[]{Float.valueOf(2.1897f), Float.valueOf(1.001f), Float.valueOf(87.23f), Float.valueOf(167.228f)};

    @Before
    public void setup() {
        this.floatAnyAggFactory = new FloatAnyAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (FloatAnyAggregatorFactory)this.floatAnyAggFactory.getCombiningFactory();
        this.valueSelector = new TestFloatColumnSelector(this.floats);
        this.objectSelector = new TestObjectColumnSelector<Float>(this.objects);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testFloatAnyAggregator() {
        Aggregator agg = this.floatAnyAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Float result = (Float)agg.get();
        Assert.assertEquals((Object)Float.valueOf(this.floats[0]), (Object)result);
        Assert.assertEquals((long)((long)this.floats[0]), (long)agg.getLong());
        Assert.assertEquals((double)this.floats[0], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testFloatAnyBufferAggregator() {
        BufferAggregator agg = this.floatAnyAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatAnyAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Float result = (Float)agg.get(buffer, 0);
        Assert.assertEquals((double)this.floats[0], (double)result.floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[0]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.floats[0], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        Float f1 = Float.valueOf(3.0f);
        Float f2 = Float.valueOf(4.0f);
        Assert.assertEquals((Object)f1, (Object)this.floatAnyAggFactory.combine((Object)f1, (Object)f2));
    }

    @Test
    public void testComparatorWithNulls() {
        Float f1 = Float.valueOf(3.0f);
        Object f2 = null;
        Comparator comparator = this.floatAnyAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(f1, f2));
        Assert.assertEquals((long)0L, (long)comparator.compare(f1, f1));
        Assert.assertEquals((long)0L, (long)comparator.compare(f2, f2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(f2, f1));
    }

    @Test
    public void testFloatAnyCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Float result = (Float)agg.get();
        Assert.assertEquals((double)this.objects[0].floatValue(), (double)result.floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)this.objects[0].longValue(), (long)agg.getLong());
        Assert.assertEquals((double)this.objects[0].floatValue(), (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testFloatAnyCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatAnyAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Float result = (Float)agg.get(buffer, 0);
        Assert.assertEquals((double)this.objects[0].floatValue(), (double)result.floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)this.objects[0].longValue(), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.objects[0].floatValue(), (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String floatSpecJson = "{\"type\":\"floatAny\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.floatAnyAggFactory, (Object)mapper.readValue(floatSpecJson, AggregatorFactory.class));
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

