/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyVectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LongAnyAggregatorFactoryTest
extends InitializedNullHandlingTest {
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final int POSITION = 2;
    private static final ByteBuffer BUFFER = ByteBuffer.allocate(128);
    @Mock
    private ColumnCapabilities capabilities;
    @Mock
    private ColumnInspector columnInspector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private VectorColumnSelectorFactory selectorFactory;
    @Mock
    private VectorValueSelector valueSelector;
    private LongAnyAggregatorFactory target;

    @Before
    public void setUp() {
        ((VectorColumnSelectorFactory)Mockito.doReturn(null).when((Object)this.selectorFactory)).getColumnCapabilities(FIELD_NAME);
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.valueSelector).when((Object)this.selectorFactory)).makeValueSelector(FIELD_NAME);
        this.target = new LongAnyAggregatorFactory(NAME, FIELD_NAME);
    }

    @Test
    public void canVectorizeShouldReturnTrue() {
        Assert.assertTrue((boolean)this.target.canVectorize(this.columnInspector));
    }

    @Test
    public void factorizeVectorShouldReturnLongVectorAggregator() {
        VectorAggregator aggregator = this.target.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)aggregator);
        Assert.assertEquals(LongAnyVectorAggregator.class, aggregator.getClass());
    }

    @Test
    public void factorizeVectorWithNumericColumnShouldReturnLongVectorAggregator() {
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.capabilities).when((Object)this.selectorFactory)).getColumnCapabilities(FIELD_NAME);
        ((ColumnCapabilities)Mockito.doReturn((Object)ValueType.LONG).when((Object)this.capabilities)).getType();
        VectorAggregator aggregator = this.target.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)aggregator);
        Assert.assertEquals(LongAnyVectorAggregator.class, aggregator.getClass());
    }

    @Test
    public void factorizeVectorForStringTypeShouldReturnLongVectorAggregatorWithNilSelector() {
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.capabilities).when((Object)this.selectorFactory)).getColumnCapabilities(FIELD_NAME);
        ((ColumnCapabilities)Mockito.doReturn((Object)ValueType.STRING).when((Object)this.capabilities)).getType();
        VectorAggregator aggregator = this.target.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)aggregator);
        Assert.assertEquals((Object)NullHandling.defaultLongValue(), (Object)aggregator.get(BUFFER, 2));
    }
}

