/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyBufferAggregator;
import org.junit.Assert;
import org.junit.Test;

public class StringAnyBufferAggregatorTest {
    private void aggregateBuffer(TestObjectColumnSelector valueSelector, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        valueSelector.increment();
    }

    @Test
    public void testBufferAggregate() {
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        Integer maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyAggregatorFactory factory = new StringAnyAggregatorFactory("billy", "billy", maxStringBytes);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes.intValue());
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)strings[0], (Object)result);
    }

    @Test
    public void testBufferAggregateWithFoldCheck() {
        String[] strings = new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"};
        Integer maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyAggregatorFactory factory = new StringAnyAggregatorFactory("billy", "billy", maxStringBytes);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes.intValue());
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)strings[0], (Object)result);
    }

    @Test
    public void testContainsNullBufferAggregate() {
        String[] strings = new String[]{"CCCC", "AAAA", "BBBB", null, "EEEE"};
        Integer maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyAggregatorFactory factory = new StringAnyAggregatorFactory("billy", "billy", maxStringBytes);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes.intValue());
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)strings[0], (Object)result);
    }

    @Test
    public void testNullFirstBufferAggregate() {
        String[] strings = new String[]{null, "CCCC", "AAAA", "BBBB", "EEEE"};
        Integer maxStringBytes = 1024;
        TestObjectColumnSelector<String> objectColumnSelector = new TestObjectColumnSelector<String>(strings);
        StringAnyAggregatorFactory factory = new StringAnyAggregatorFactory("billy", "billy", maxStringBytes);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes.intValue());
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < strings.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testNonStringValue() {
        Double[] doubles = new Double[]{1.0, 2.0};
        Integer maxStringBytes = 1024;
        TestObjectColumnSelector<Double> objectColumnSelector = new TestObjectColumnSelector<Double>(doubles);
        StringAnyAggregatorFactory factory = new StringAnyAggregatorFactory("billy", "billy", maxStringBytes);
        StringAnyBufferAggregator agg = new StringAnyBufferAggregator(objectColumnSelector, maxStringBytes.intValue());
        ByteBuffer buf = ByteBuffer.allocate(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        for (int i = 0; i < doubles.length; ++i) {
            this.aggregateBuffer(objectColumnSelector, (BufferAggregator)agg, buf, position);
        }
        String result = (String)agg.get(buf, position);
        Assert.assertEquals((Object)"1.0", (Object)result);
    }
}

