/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality;

import java.nio.ByteBuffer;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.CardinalityVectorAggregator;
import org.apache.druid.query.aggregation.cardinality.vector.DoubleCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.FloatCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.LongCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.MultiValueStringCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.SingleValueStringCardinalityVectorProcessor;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseFloatVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class CardinalityVectorAggregatorTest
extends InitializedNullHandlingTest {
    @Test
    public void testAggregateLong() {
        boolean[] blArray;
        final long[] values = new long[]{1L, 2L, 2L, 3L, 3L, 3L, 0L};
        if (NullHandling.replaceWithDefault()) {
            blArray = null;
        } else {
            boolean[] blArray2 = new boolean[7];
            blArray2[0] = false;
            blArray2[1] = false;
            blArray2[2] = false;
            blArray2[3] = false;
            blArray2[4] = false;
            blArray2[5] = false;
            blArray = blArray2;
            blArray2[6] = true;
        }
        final boolean[] nulls = blArray;
        CardinalityVectorAggregator aggregator = new CardinalityVectorAggregator(Collections.singletonList(new LongCardinalityVectorProcessor((VectorValueSelector)new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(values.length, 0, values.length)){

            public long[] getLongVector() {
                return values;
            }

            @Nullable
            public boolean[] getNullVector() {
                return nulls;
            }
        })));
        CardinalityVectorAggregatorTest.testAggregate(aggregator, values.length, NullHandling.replaceWithDefault() ? 4.0 : 3.0);
    }

    @Test
    public void testAggregateDouble() {
        boolean[] blArray;
        final double[] values = new double[]{1.0, 2.0, 2.0, 3.0, 3.0, 3.0, 0.0};
        if (NullHandling.replaceWithDefault()) {
            blArray = null;
        } else {
            boolean[] blArray2 = new boolean[7];
            blArray2[0] = false;
            blArray2[1] = false;
            blArray2[2] = false;
            blArray2[3] = false;
            blArray2[4] = false;
            blArray2[5] = false;
            blArray = blArray2;
            blArray2[6] = true;
        }
        final boolean[] nulls = blArray;
        CardinalityVectorAggregator aggregator = new CardinalityVectorAggregator(Collections.singletonList(new DoubleCardinalityVectorProcessor((VectorValueSelector)new BaseDoubleVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(values.length, 0, values.length)){

            public double[] getDoubleVector() {
                return values;
            }

            @Nullable
            public boolean[] getNullVector() {
                return nulls;
            }
        })));
        CardinalityVectorAggregatorTest.testAggregate(aggregator, values.length, NullHandling.replaceWithDefault() ? 4.0 : 3.0);
    }

    @Test
    public void testAggregateFloat() {
        boolean[] blArray;
        final float[] values = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 3.0f, 3.0f, 0.0f};
        if (NullHandling.replaceWithDefault()) {
            blArray = null;
        } else {
            boolean[] blArray2 = new boolean[7];
            blArray2[0] = false;
            blArray2[1] = false;
            blArray2[2] = false;
            blArray2[3] = false;
            blArray2[4] = false;
            blArray2[5] = false;
            blArray = blArray2;
            blArray2[6] = true;
        }
        final boolean[] nulls = blArray;
        CardinalityVectorAggregator aggregator = new CardinalityVectorAggregator(Collections.singletonList(new FloatCardinalityVectorProcessor((VectorValueSelector)new BaseFloatVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(values.length, 0, values.length)){

            public float[] getFloatVector() {
                return values;
            }

            @Nullable
            public boolean[] getNullVector() {
                return nulls;
            }
        })));
        CardinalityVectorAggregatorTest.testAggregate(aggregator, values.length, NullHandling.replaceWithDefault() ? 4.0 : 3.0);
    }

    @Test
    public void testAggregateSingleValueString() {
        final int[] ids = new int[]{1, 2, 2, 3, 3, 3, 0};
        final String[] dict = new String[]{null, "abc", "def", "foo"};
        CardinalityVectorAggregator aggregator = new CardinalityVectorAggregator(Collections.singletonList(new SingleValueStringCardinalityVectorProcessor(new SingleValueDimensionVectorSelector(){

            public int[] getRowVector() {
                return ids;
            }

            public int getValueCardinality() {
                return dict.length;
            }

            @Nullable
            public String lookupName(int id) {
                return dict[id];
            }

            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            public int getMaxVectorSize() {
                return ids.length;
            }

            public int getCurrentVectorSize() {
                return ids.length;
            }
        })));
        CardinalityVectorAggregatorTest.testAggregate(aggregator, ids.length, NullHandling.replaceWithDefault() ? 4.0 : 3.0);
    }

    @Test
    public void testAggregateMultiValueString() {
        final IndexedInts[] ids = new IndexedInts[]{new ArrayBasedIndexedInts(new int[]{1, 2}), new ArrayBasedIndexedInts(new int[]{2, 3}), new ArrayBasedIndexedInts(new int[]{3, 3}), new ArrayBasedIndexedInts(new int[]{0})};
        final String[] dict = new String[]{null, "abc", "def", "foo"};
        CardinalityVectorAggregator aggregator = new CardinalityVectorAggregator(Collections.singletonList(new MultiValueStringCardinalityVectorProcessor(new MultiValueDimensionVectorSelector(){

            public IndexedInts[] getRowVector() {
                return ids;
            }

            public int getValueCardinality() {
                return dict.length;
            }

            @Nullable
            public String lookupName(int id) {
                return dict[id];
            }

            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            public int getMaxVectorSize() {
                return ids.length;
            }

            public int getCurrentVectorSize() {
                return ids.length;
            }
        })));
        CardinalityVectorAggregatorTest.testAggregate(aggregator, ids.length, NullHandling.replaceWithDefault() ? 4.0 : 3.0);
    }

    private static void testAggregate(CardinalityVectorAggregator aggregator, int numRows, double expectedResult) {
        CardinalityVectorAggregatorTest.testAggregateStyle1(aggregator, numRows, expectedResult);
        CardinalityVectorAggregatorTest.testAggregateStyle2(aggregator, numRows, expectedResult);
    }

    private static void testAggregateStyle1(CardinalityVectorAggregator aggregator, int numRows, double expectedResult) {
        boolean position = true;
        ByteBuffer buf = ByteBuffer.allocate(HyperLogLogCollector.getLatestNumBytesForDenseStorage() + 1);
        aggregator.init(buf, 1);
        aggregator.aggregate(buf, 1, 0, numRows);
        Assert.assertEquals((String)"style1", (double)expectedResult, (double)((HyperLogLogCollector)aggregator.get(buf, 1)).estimateCardinality(), (double)0.01);
    }

    private static void testAggregateStyle2(CardinalityVectorAggregator aggregator, int numRows, double expectedResult) {
        boolean positionOffset = true;
        int aggregatorSize = HyperLogLogCollector.getLatestNumBytesForDenseStorage();
        ByteBuffer buf = ByteBuffer.allocate(1 + 2 * aggregatorSize);
        aggregator.init(buf, 1);
        aggregator.init(buf, 1 + aggregatorSize);
        int[] positions = new int[numRows];
        int[] rows = new int[numRows];
        for (int i = 0; i < numRows; ++i) {
            positions[i] = i % 2 * aggregatorSize;
            rows[i] = (i + 1) % numRows;
        }
        aggregator.aggregate(buf, numRows, positions, rows, 1);
        Assert.assertEquals((String)"style2", (double)expectedResult, (double)((HyperLogLogCollector)aggregator.get(buf, 1)).fold((HyperLogLogCollector)aggregator.get(buf, 1 + aggregatorSize)).estimateCardinality(), (double)0.01);
    }
}

