/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleFirstAggregationTest
extends InitializedNullHandlingTest {
    private DoubleFirstAggregatorFactory doubleFirstAggFactory;
    private DoubleFirstAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestDoubleColumnSelectorImpl valueSelector;
    private TestObjectColumnSelector objectSelector;
    private double[] doubleValues = new double[]{1.1, 2.7, 3.5, 1.3};
    private long[] times = new long[]{12L, 10L, 5344L, 7899999L};
    private SerializablePair[] pairs = new SerializablePair[]{new SerializablePair((Object)1467225096L, (Object)134.3), new SerializablePair((Object)23163L, (Object)1232.212), new SerializablePair((Object)742L, (Object)18.0), new SerializablePair((Object)111111L, (Object)233.5232)};

    @Before
    public void setup() {
        this.doubleFirstAggFactory = new DoubleFirstAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (DoubleFirstAggregatorFactory)this.doubleFirstAggFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.valueSelector = new TestDoubleColumnSelectorImpl(this.doubleValues);
        this.objectSelector = new TestObjectColumnSelector<SerializablePair>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testDoubleFirstAggregator() {
        Aggregator agg = this.doubleFirstAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[1], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.doubleValues[1], (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.doubleValues[1]), (long)agg.getLong());
        Assert.assertEquals((double)this.doubleValues[1], (double)agg.getDouble(), (double)1.0E-4);
    }

    @Test
    public void testDoubleFirstBufferAggregator() {
        BufferAggregator agg = this.doubleFirstAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.doubleFirstAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[1], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.doubleValues[1], (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.doubleValues[1]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.doubleValues[1], (double)agg.getDouble(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)3.621);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)785.4);
        Assert.assertEquals((Object)pair1, (Object)this.doubleFirstAggFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testComparator() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)3.621);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)785.4);
        Comparator comparator = this.doubleFirstAggFactory.getComparator();
        Assert.assertEquals((long)-1L, (long)comparator.compare(pair1, pair2));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair1, pair1));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair2, pair2));
        Assert.assertEquals((long)1L, (long)comparator.compare(pair2, pair1));
    }

    @Test
    public void testComparatorWithNulls() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)3.621);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, null);
        Comparator comparator = this.doubleFirstAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(pair1, pair2));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair1, pair1));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair2, pair2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(pair2, pair1));
    }

    @Test
    public void testDoubleFirstCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Double)expected.rhs), (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((Double)expected.rhs).longValue(), (long)agg.getLong());
        Assert.assertEquals((double)((Double)expected.rhs), (double)agg.getDouble(), (double)1.0E-4);
    }

    @Test
    public void testDoubleFirstCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.doubleFirstAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Double)expected.rhs), (double)((Double)result.rhs), (double)1.0E-4);
        Assert.assertEquals((long)((Double)expected.rhs).longValue(), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)((Double)expected.rhs), (double)agg.getDouble(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String doubleSpecJson = "{\"type\":\"doubleFirst\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.doubleFirstAggFactory, (Object)mapper.readValue(doubleSpecJson, AggregatorFactory.class));
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

