/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HyperUniqueFinalizingPostAggregatorTest {
    private final HashFunction fn = Hashing.murmur3_128();

    @Test
    public void testCompute() {
        Random random = new Random(0L);
        HyperUniqueFinalizingPostAggregator postAggregator = new HyperUniqueFinalizingPostAggregator("uniques", "uniques");
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        for (int i = 0; i < 100; ++i) {
            byte[] hashedVal = this.fn.hashLong(random.nextLong()).asBytes();
            collector.add(hashedVal);
        }
        double cardinality = (Double)postAggregator.compute((Map)ImmutableMap.of((Object)"uniques", (Object)collector));
        Assert.assertTrue((cardinality == 99.37233005831612 ? 1 : 0) != 0);
    }

    @Test
    public void testComputeRounded() {
        Random random = new Random(0L);
        HyperUniqueFinalizingPostAggregator postAggregator = new HyperUniqueFinalizingPostAggregator("uniques", "uniques").decorate((Map)ImmutableMap.of((Object)"uniques", (Object)new CardinalityAggregatorFactory("uniques", null, Collections.singletonList(DefaultDimensionSpec.of((String)"dummy")), false, true)));
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        for (int i = 0; i < 100; ++i) {
            byte[] hashedVal = this.fn.hashLong(random.nextLong()).asBytes();
            collector.add(hashedVal);
        }
        Object cardinality = postAggregator.compute((Map)ImmutableMap.of((Object)"uniques", (Object)collector));
        Assert.assertThat((Object)cardinality, (Matcher)CoreMatchers.instanceOf(Long.class));
        Assert.assertEquals((Object)99L, (Object)cardinality);
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new HyperUniquesAggregatorFactory("approxCount", "col"), new HyperUniquesAggregatorFactory("approxCountRound", "col", false, true)}).postAggregators(new PostAggregator[]{new HyperUniqueFinalizingPostAggregator("a", "approxCount"), new HyperUniqueFinalizingPostAggregator("b", "approxCountRound")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("approxCount", null).add("approxCountRound", null).add("a", ValueType.DOUBLE).add("b", ValueType.LONG).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

