/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class DefaultDimensionSpecTest {
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Test
    public void testEqualsSerde() throws IOException {
        String name = "foo";
        DefaultDimensionSpec spec = new DefaultDimensionSpec("foo", "foo");
        String json = this.mapper.writeValueAsString((Object)spec);
        DimensionSpec other = (DimensionSpec)this.mapper.readValue(json, DimensionSpec.class);
        Assert.assertEquals((Object)spec.toString(), (Object)other.toString());
        Assert.assertEquals((Object)spec, (Object)other);
        Assert.assertEquals((long)spec.hashCode(), (long)other.hashCode());
    }

    @Test
    public void testEqualsSerdeWithType() throws IOException {
        String name = "foo";
        DefaultDimensionSpec spec = new DefaultDimensionSpec("foo", "foo", ValueType.FLOAT);
        String json = this.mapper.writeValueAsString((Object)spec);
        DimensionSpec other = (DimensionSpec)this.mapper.readValue(json, DimensionSpec.class);
        Assert.assertEquals((Object)spec.toString(), (Object)other.toString());
        Assert.assertEquals((Object)spec, (Object)other);
        Assert.assertEquals((long)spec.hashCode(), (long)other.hashCode());
    }

    @Test
    public void testCacheKey() {
        DefaultDimensionSpec spec = new DefaultDimensionSpec("foo", "foo", ValueType.FLOAT);
        byte[] expected = new byte[]{0, 7, 102, 111, 111, 7, 70, 76, 79, 65, 84};
        Assert.assertArrayEquals((byte[])expected, (byte[])spec.getCacheKey());
    }
}

