/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.query.expression.IPv4AddressExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class IPv4AddressExprUtilsTest {
    private static final List<String> VALID_IPV4_ADDRESSES = Arrays.asList("192.168.0.1", "0.0.0.0", "255.255.255.255", "255.0.0.0", "0.255.0.0", "0.0.255.0", "0.0.0.255");
    private static final List<String> INVALID_IPV4_ADDRESSES = Arrays.asList("druid.apache.org", "a.b.c.d", "abc.def.ghi.jkl", "1..3.4", "1.2..4", "1.2.3..", "1", "1.2", "1.2.3", "1.2.3.4.5", "256.0.0.0", "0.265.0.0", "0.0.266.0", "0.0.0.355", "a.2.3.4", "1.a.3.4", "1.2.c.4", "1.2.3.d");
    private static final String IPV6_MAPPED = "::ffff:192.168.0.1";
    private static final String IPV6_COMPATIBLE = "::192.168.0.1";

    @Test
    public void testOverflowsUnsignedIntTooLow() {
        Assert.assertTrue((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)-1L));
    }

    @Test
    public void testOverflowsUnsignedIntLowest() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)0L));
    }

    @Test
    public void testOverflowsUnsignedIntMiddle() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)65535L));
    }

    @Test
    public void testOverflowsUnsignedIntHighest() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)0xFFFFFFFFL));
    }

    @Test
    public void testOverflowsUnsignedIntTooHigh() {
        Assert.assertTrue((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)0x100000000L));
    }

    @Test
    public void testIsValidAddressNull() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.isValidAddress(null));
    }

    @Test
    public void testIsValidAddressIPv4() {
        for (String address : VALID_IPV4_ADDRESSES) {
            Assert.assertTrue((String)this.getErrMsg(address), (boolean)IPv4AddressExprUtils.isValidAddress((String)address));
        }
    }

    @Test
    public void testIsValidAddressIPv6Mapped() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.isValidAddress((String)IPV6_MAPPED));
    }

    @Test
    public void testIsValidAddressIPv6Compatible() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.isValidAddress((String)IPV6_COMPATIBLE));
    }

    @Test
    public void testIsValidAddressNotIpAddress() {
        for (String address : INVALID_IPV4_ADDRESSES) {
            Assert.assertFalse((String)this.getErrMsg(address), (boolean)IPv4AddressExprUtils.isValidAddress((String)address));
        }
    }

    @Test
    public void testParseNull() {
        Assert.assertNull((Object)IPv4AddressExprUtils.parse(null));
    }

    @Test
    public void testParseIPv4() {
        for (String string : VALID_IPV4_ADDRESSES) {
            String errMsg = this.getErrMsg(string);
            Inet4Address address = IPv4AddressExprUtils.parse((String)string);
            Assert.assertNotNull((String)errMsg, (Object)address);
            Assert.assertEquals((String)errMsg, (Object)string, (Object)address.getHostAddress());
        }
    }

    @Test
    public void testParseIPv6Mapped() {
        Assert.assertNull((Object)IPv4AddressExprUtils.parse((String)IPV6_MAPPED));
    }

    @Test
    public void testParseIPv6Compatible() {
        Assert.assertNull((Object)IPv4AddressExprUtils.parse((String)IPV6_COMPATIBLE));
    }

    @Test
    public void testParseNotIpAddress() {
        for (String address : INVALID_IPV4_ADDRESSES) {
            Assert.assertNull((String)this.getErrMsg(address), (Object)IPv4AddressExprUtils.parse((String)address));
        }
    }

    @Test
    public void testParseInt() {
        Inet4Address address = IPv4AddressExprUtils.parse((int)-1062731775);
        Assert.assertArrayEquals((byte[])new byte[]{-64, -88, 0, 1}, (byte[])address.getAddress());
    }

    @Test
    public void testToString() throws UnknownHostException {
        byte[] bytes = new byte[]{-64, -88, 0, 1};
        InetAddress address = InetAddress.getByAddress(bytes);
        Assert.assertEquals((Object)"192.168.0.1", (Object)IPv4AddressExprUtils.toString((Inet4Address)((Inet4Address)address)));
    }

    @Test
    public void testToLong() throws UnknownHostException {
        byte[] bytes = new byte[]{-64, -88, 0, 1};
        InetAddress address = InetAddress.getByAddress(bytes);
        Assert.assertEquals((long)3232235521L, (long)IPv4AddressExprUtils.toLong((Inet4Address)((Inet4Address)address)));
    }

    private String getErrMsg(String msg) {
        String prefix = "Failed: ";
        return prefix + msg;
    }
}

