/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.MacroTestBase;
import org.apache.druid.query.expression.RegexpExtractExprMacro;
import org.junit.Assert;
import org.junit.Test;

public class RegexpExtractExprMacroTest
extends MacroTestBase {
    public RegexpExtractExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new RegexpExtractExprMacro());
    }

    @Test
    public void testErrorZeroArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] must have 2 to 3 arguments");
        this.eval("regexp_extract()", InputBindings.withMap((Map)ImmutableMap.of()));
    }

    @Test
    public void testErrorFourArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] must have 2 to 3 arguments");
        this.eval("regexp_extract('a', 'b', 'c', 'd')", InputBindings.withMap((Map)ImmutableMap.of()));
    }

    @Test
    public void testMatch() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.o)')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)"foo", (Object)result.value());
    }

    @Test
    public void testMatchGroup0() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.o)', 0)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)"foo", (Object)result.value());
    }

    @Test
    public void testMatchGroup1() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.o)', 1)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)"oo", (Object)result.value());
    }

    @Test
    public void testMatchGroup2() {
        this.expectedException.expectMessage("No group 2");
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.o)', 2)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
    }

    @Test
    public void testNoMatch() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.x)')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testMatchInMiddle() {
        ExprEval<?> result = this.eval("regexp_extract(a, '.o$')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)"oo", (Object)result.value());
    }

    @Test
    public void testNullPattern() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        }
        ExprEval<?> result = this.eval("regexp_extract(a, null)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testEmptyStringPattern() {
        ExprEval<?> result = this.eval("regexp_extract(a, '')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)NullHandling.emptyToNullIfNeeded((String)""), (Object)result.value());
    }

    @Test
    public void testNumericPattern() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        this.eval("regexp_extract(a, 1)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
    }

    @Test
    public void testNonLiteralPattern() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        this.eval("regexp_extract(a, a)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
    }

    @Test
    public void testNullPatternOnNull() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        }
        ExprEval<?> result = this.eval("regexp_extract(a, null)", InputBindings.withSuppliers((Map)ImmutableMap.of((Object)"a", () -> null)));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testEmptyStringPatternOnNull() {
        ExprEval<?> result = this.eval("regexp_extract(a, '')", InputBindings.withSuppliers((Map)ImmutableMap.of((Object)"a", () -> null)));
        Assert.assertNull((Object)result.value());
    }
}

