/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.expression.TimestampExtractExprMacro;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimestampExtractExprMacroTest {
    private TimestampExtractExprMacro target;

    @Before
    public void setUp() {
        this.target = new TimestampExtractExprMacro();
    }

    @Test
    public void testApplyExtractDecadeShouldExtractTheCorrectDecade() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2001-02-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.DECADE.toString()).toExpr()));
        Assert.assertEquals((long)200L, (long)expression.eval(ExprUtils.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractCenturyShouldExtractTheCorrectCentury() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2000-12-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.CENTURY.toString()).toExpr()));
        Assert.assertEquals((long)20L, (long)expression.eval(ExprUtils.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractCenturyShouldBeTwentyFirstCenturyIn2001() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2001-02-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.CENTURY.toString()).toExpr()));
        Assert.assertEquals((long)21L, (long)expression.eval(ExprUtils.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractMilleniumShouldExtractTheCorrectMillenium() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2000-12-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.MILLENNIUM.toString()).toExpr()));
        Assert.assertEquals((long)2L, (long)expression.eval(ExprUtils.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractMilleniumShouldBeThirdMilleniumIn2001() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2001-02-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.MILLENNIUM.toString()).toExpr()));
        Assert.assertEquals((long)3L, (long)expression.eval(ExprUtils.nilBindings()).asInt());
    }

    static {
        NullHandling.initializeForTests();
    }
}

