/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryEngine;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.query.groupby.strategy.GroupByStrategyV1;
import org.apache.druid.query.groupby.strategy.GroupByStrategyV2;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByQueryRunnerFailureTest {
    private static final DruidProcessingConfig DEFAULT_PROCESSING_CONFIG = new DruidProcessingConfig(){

        public String getFormatString() {
            return null;
        }

        public int intermediateComputeSizeBytes() {
            return 0xA00000;
        }

        public int getNumMergeBuffers() {
            return 1;
        }

        public int getNumThreads() {
            return 2;
        }
    };
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final CloseableStupidPool<ByteBuffer> BUFFER_POOL = new CloseableStupidPool("GroupByQueryEngine-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

        public ByteBuffer get() {
            return ByteBuffer.allocateDirect(DEFAULT_PROCESSING_CONFIG.intermediateComputeSizeBytes());
        }
    });
    private static final CloseableDefaultBlockingPool<ByteBuffer> MERGE_BUFFER_POOL = new CloseableDefaultBlockingPool((Supplier)new Supplier<ByteBuffer>(){

        public ByteBuffer get() {
            return ByteBuffer.allocateDirect(DEFAULT_PROCESSING_CONFIG.intermediateComputeSizeBytes());
        }
    }, DEFAULT_PROCESSING_CONFIG.getNumMergeBuffers());
    private static final GroupByQueryRunnerFactory FACTORY = GroupByQueryRunnerFailureTest.makeQueryRunnerFactory(GroupByQueryRunnerTest.DEFAULT_MAPPER, new GroupByQueryConfig(){

        public String getDefaultStrategy() {
            return "v2";
        }
    });
    private QueryRunner<ResultRow> runner;

    private static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config) {
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, BUFFER_POOL), QueryRunnerTestHelper.NOOP_QUERYWATCHER, BUFFER_POOL), new GroupByStrategyV2(DEFAULT_PROCESSING_CONFIG, configSupplier, BUFFER_POOL, MERGE_BUFFER_POOL, mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER));
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(strategySelector);
        return new GroupByQueryRunnerFactory(strategySelector, toolChest);
    }

    @AfterClass
    public static void teardownClass() {
        BUFFER_POOL.close();
        MERGE_BUFFER_POOL.close();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (QueryRunner runner : QueryRunnerTestHelper.makeQueryRunners(FACTORY)) {
            args.add(new Object[]{runner});
        }
        return args;
    }

    public GroupByQueryRunnerFailureTest(QueryRunner<ResultRow> runner) {
        this.runner = FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)ImmutableList.of(runner));
    }

    @Test(timeout=60000L)
    public void testNotEnoughMergeBuffersOnQueryable() {
        this.expectedException.expect(QueryTimeoutException.class);
        this.expectedException.expectMessage("Cannot acquire enough merge buffers");
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)500)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
    }

    @Test(timeout=60000L)
    public void testResourceLimitExceededOnBroker() {
        this.expectedException.expect(ResourceLimitExceededException.class);
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null)}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build()).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)500)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
    }

    @Test(timeout=60000L)
    public void testInsufficientResourcesOnBroker() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)500)).build();
        List holder = null;
        try {
            holder = MERGE_BUFFER_POOL.takeBatch(1, 10L);
            this.expectedException.expect(QueryCapacityExceededException.class);
            this.expectedException.expectMessage("Cannot acquire 1 merge buffers. Try again after current running queries are finished.");
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        }
        finally {
            if (holder != null) {
                holder.forEach(ReferenceCountingResourceHolder::close);
            }
        }
    }

    @Test(timeout=60000L)
    public void testTimeoutExceptionOnQueryable() {
        this.expectedException.expect(QueryTimeoutException.class);
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).overrideContext((Map)ImmutableMap.of((Object)"timeout", (Object)1)).build();
        GroupByQueryRunnerFactory factory = GroupByQueryRunnerFailureTest.makeQueryRunnerFactory(GroupByQueryRunnerTest.DEFAULT_MAPPER, new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public boolean isSingleThreaded() {
                return true;
            }
        });
        QueryRunner mergeRunners = factory.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)ImmutableList.of(this.runner));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, mergeRunners, query);
    }
}

