/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LimitedBufferHashGrouperTest
extends InitializedNullHandlingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testLimitAndBufferSwapping() {
        int i;
        int limit = 100;
        int keyBase = 100000;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<Integer> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 20000, 2, 100);
        int numRows = 1000;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)(i + 100000)).isOk());
        }
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)12L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)112L, (long)grouper.getSize());
            Assert.assertEquals((long)349L, (long)grouper.getBuckets());
            Assert.assertEquals((long)174L, (long)grouper.getMaxSize());
        } else {
            Assert.assertEquals((long)13L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)116L, (long)grouper.getSize());
            Assert.assertEquals((long)337L, (long)grouper.getBuckets());
            Assert.assertEquals((long)168L, (long)grouper.getMaxSize());
        }
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)25L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)150L, (long)grouper.getSize());
            Assert.assertEquals((long)349L, (long)grouper.getBuckets());
            Assert.assertEquals((long)174L, (long)grouper.getMaxSize());
        } else {
            Assert.assertEquals((long)27L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)164L, (long)grouper.getSize());
            Assert.assertEquals((long)337L, (long)grouper.getBuckets());
            Assert.assertEquals((long)168L, (long)grouper.getMaxSize());
        }
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        ArrayList<Grouper.Entry> expected = new ArrayList<Grouper.Entry>();
        for (int i2 = 0; i2 < 100; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{11L, 1L}));
        }
        Assert.assertEquals(expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
        Assert.assertEquals(expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    @Test
    public void testBufferTooSmall() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("LimitedBufferHashGrouper initialized with insufficient buffer capacity");
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 10, 2, 100);
    }

    @Test
    public void testMinBufferSize() {
        int i;
        int limit = 100;
        int keyBase = 100000;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<Integer> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 12120, 2, 100);
        int numRows = 1000;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)(i + 100000)).isOk());
        }
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)224L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)104L, (long)grouper.getSize());
            Assert.assertEquals((long)209L, (long)grouper.getBuckets());
            Assert.assertEquals((long)104L, (long)grouper.getMaxSize());
        } else {
            Assert.assertEquals((long)899L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)101L, (long)grouper.getSize());
            Assert.assertEquals((long)202L, (long)grouper.getBuckets());
            Assert.assertEquals((long)101L, (long)grouper.getMaxSize());
        }
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)474L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)104L, (long)grouper.getSize());
            Assert.assertEquals((long)209L, (long)grouper.getBuckets());
            Assert.assertEquals((long)104L, (long)grouper.getMaxSize());
        } else {
            Assert.assertEquals((long)1899L, (long)grouper.getGrowthCount());
            Assert.assertEquals((long)101L, (long)grouper.getSize());
            Assert.assertEquals((long)202L, (long)grouper.getBuckets());
            Assert.assertEquals((long)101L, (long)grouper.getMaxSize());
        }
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        ArrayList<Grouper.Entry> expected = new ArrayList<Grouper.Entry>();
        for (int i2 = 0; i2 < 100; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{11L, 1L}));
        }
        Assert.assertEquals(expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
        Assert.assertEquals(expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    @Test
    public void testAggregateAfterIterated() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("attempted to add offset after grouper was iterated");
        int limit = 100;
        int keyBase = 100000;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<Integer> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 12120, 2, 100);
        int numRows = 1000;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)(i + 100000)).isOk());
        }
        ArrayList iterated = Lists.newArrayList((Iterator)grouper.iterator(true));
        Assert.assertEquals((long)100L, (long)iterated.size());
        grouper.aggregate((Object)101001);
    }

    private static LimitedBufferHashGrouper<Integer> makeGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize, int initialBuckets, int limit) {
        LimitedBufferHashGrouper grouper = new LimitedBufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(bufferSize)), GrouperTestUtil.intKeySerde(), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, 0.5f, initialBuckets, limit, false);
        grouper.init();
        return grouper;
    }
}

