/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ListColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentMetadataUnionQueryTest
extends InitializedNullHandlingTest {
    private static final QueryRunnerFactory FACTORY;
    private final QueryRunner runner;
    private final boolean mmap;

    public SegmentMetadataUnionQueryTest(QueryRunner runner, boolean mmap) {
        this.runner = runner;
        this.mmap = mmap;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{QueryRunnerTestHelper.makeUnionQueryRunner(FACTORY, (Segment)new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), QueryRunnerTestHelper.SEGMENT_ID), null), true}, (Object)new Object[]{QueryRunnerTestHelper.makeUnionQueryRunner(FACTORY, (Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), QueryRunnerTestHelper.SEGMENT_ID), null), false});
    }

    @Test
    public void testSegmentMetadataUnionQuery() {
        SegmentAnalysis expected = new SegmentAnalysis(QueryRunnerTestHelper.SEGMENT_ID.toString(), Collections.singletonList(Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, false, this.mmap ? 43524L : 43056L, Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null)), this.mmap ? 800544L : 803324L, 4836L, null, null, null, null);
        SegmentMetadataQuery query = new Druids.SegmentMetadataQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.UNION_DATA_SOURCE).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).toInclude((ColumnIncluderator)new ListColumnIncluderator(Collections.singletonList("placement"))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE, SegmentMetadataQuery.AnalysisType.INTERVAL, SegmentMetadataQuery.AnalysisType.MINMAX}).build();
        List result = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)expected), result, "failed SegmentMetadata union query");
    }

    static {
        NullHandling.initializeForTests();
        FACTORY = new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    }
}

