/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScanQueryRunnerTest
extends InitializedNullHandlingTest {
    private static final VirtualColumn EXPR_COLUMN = new ExpressionVirtualColumn("expr", "index * 2", ValueType.LONG, TestExprMacroTable.INSTANCE);
    public static final String[] V_0112 = ScanQueryRunnerTest.readLinesFromSample(0, 13).toArray(new String[0]);
    public static final String[] V_0113 = ScanQueryRunnerTest.readLinesFromSample(13, 26).toArray(new String[0]);
    public static final QuerySegmentSpec I_0112_0114 = new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z"));
    public static final String[] V_0112_0114 = (String[])ObjectArrays.concat((Object[])V_0112, (Object[])V_0113, String.class);
    private static final ScanQueryQueryToolChest TOOL_CHEST = new ScanQueryQueryToolChest(new ScanQueryConfig(), DefaultGenericQueryMetricsFactory.instance());
    private final QueryRunner runner;
    private final boolean legacy;

    private static List<String> readLinesFromSample(final int startLineNum, final int endLineNum) {
        CharSource sampleData = TestIndex.getResourceCharSource("druid.sample.numeric.tsv");
        final ArrayList<String> lines = new ArrayList<String>();
        try {
            sampleData.readLines((LineProcessor)new LineProcessor<Object>(){
                int count = 0;

                public boolean processLine(String line) {
                    if (this.count >= startLineNum && this.count < endLineNum) {
                        lines.add(line);
                    }
                    ++this.count;
                    return this.count < endLineNum;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lines;
    }

    @Parameterized.Parameters(name="{0}, legacy = {1}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.cartesian(new Iterable[]{QueryRunnerTestHelper.makeQueryRunners(new ScanQueryRunnerFactory(TOOL_CHEST, new ScanQueryEngine(), new ScanQueryConfig())), ImmutableList.of((Object)false, (Object)true)});
    }

    public ScanQueryRunnerTest(QueryRunner runner, boolean legacy) {
        this.runner = runner;
        this.legacy = legacy;
    }

    private Druids.ScanQueryBuilder newTestQuery() {
        return Druids.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("testing")).columns(Collections.emptyList()).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).limit(3L).legacy(Boolean.valueOf(this.legacy));
    }

    @Test
    public void testFullOnSelect() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "expr", "market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "longNumericNull", "floatNumericNull", "doubleNumericNull", "placement", "placementish", "partial_null_column", "null_column", "index", "indexMin", "indexMaxPlusTen", "quality_uniques", "indexFloat", "indexMaxFloat", "indexMinFloat"});
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), columns, 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullOnSelectAsCompactedList() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "expr", "market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "longNumericNull", "floatNumericNull", "doubleNumericNull", "placement", "placementish", "partial_null_column", "null_column", "index", "indexMin", "indexMaxPlusTen", "quality_uniques", "indexFloat", "indexMaxFloat", "indexMinFloat"});
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), columns, 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(this.compactedListToRow(results), "null_column"));
    }

    @Test
    public void testSelectWithUnderscoreUnderscoreTime() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"__time", "market", "index"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<List<Map<String, Object>>> expectedEvents = this.toEvents(new String[]{this.getTimestampName() + ":TIME", "market:STRING", null, null, null, null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114});
        if (this.legacy) {
            for (List<Map<String, Object>> batch : expectedEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", ((DateTime)event.get("timestamp")).getMillis());
                }
            }
        }
        List<ScanResultValue> expectedResults = this.toExpected(expectedEvents, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "__time", "market", "index"}) : Lists.newArrayList((Object[])new String[]{"__time", "market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithDimsAndMets() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"market", "index"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, "market:STRING", null, null, null, null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114}), this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "market", "index"}) : Lists.newArrayList((Object[])new String[]{"market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithDimsAndMetsAsCompactedList() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"market", "index"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, "market:STRING", null, null, null, null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114}), this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "market", "index"}) : Lists.newArrayList((Object[])new String[]{"market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, this.compactedListToRow(results));
    }

    @Test
    public void testFullOnSelectWithFilterAndLimit() {
        for (int limit : new int[]{3, 1, 5, 7, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"quality", "index"}).limit((long)limit).build();
            List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            List<List<Map<String, Object>>> events = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, null, "quality:STRING", null, null, "index:DOUBLE"}, {"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"}, {"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"});
            List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"quality", "index"}), 0, limit);
            ScanQueryRunnerTest.verify(expectedResults, results);
        }
    }

    @Test
    public void testSelectWithFilterLookupExtractionFn() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("total_market", "replaced");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "replaced", (ExtractionFn)lookupExtractionFn)).columns(new String[]{"quality", "index"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List resultsOptimize = TOOL_CHEST.postMergeQueryDecoration(TOOL_CHEST.mergeResults(TOOL_CHEST.preMergeQueryDecoration(this.runner))).run(QueryPlus.wrap((Query)query)).toList();
        List<List<Map<String, Object>>> events = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : null, null, "quality:STRING", null, null, "index:DOUBLE"}, {"2011-01-12T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1000.000000"}, {"2011-01-13T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1040.945505", "2011-01-13T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1689.012875"});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"quality", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
        ScanQueryRunnerTest.verify(expectedResults, resultsOptimize);
    }

    @Test
    public void testFullSelectNoResults() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "foo", null)))).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = Collections.emptyList();
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullSelectNoDimensionAndMetric() {
        String[] stringArray;
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"foo", "foo2"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        if (this.legacy) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getTimestampName() + ":TIME";
        } else {
            stringArray = new String[]{};
        }
        List<List<Map<String, Object>>> events = this.toEvents(stringArray, new String[][]{V_0112_0114});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "foo", "foo2"}) : Lists.newArrayList((Object[])new String[]{"foo", "foo2"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndAscendingTimeOrderingListFormat() {
        for (int limit : new int[]{3, 1, 5, 7, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).limit((long)limit).order(ScanQuery.Order.ASCENDING).context((Map)ImmutableMap.of((Object)"scanOutermost", (Object)false)).build();
            List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
            Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
            List<List<Map<String, Object>>> ascendingEvents = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : "__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{(String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results)});
            if (this.legacy) {
                for (List<Map<String, Object>> batch : ascendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", ((DateTime)event.get("timestamp")).getMillis());
                    }
                }
            } else {
                for (List<Map<String, Object>> batch : ascendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                    }
                }
            }
            List<ScanResultValue> ascendingExpectedResults = this.toExpected(ascendingEvents, this.legacy ? Lists.newArrayList((Object[])new String[]{"__time", this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            ScanQueryRunnerTest.verify(ascendingExpectedResults, results);
        }
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndDescendingTimeOrderingListFormat() {
        for (int limit : new int[]{3, 1, 5, 7, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).limit((long)limit).order(ScanQuery.Order.DESCENDING).build();
            List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
            Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
            Object[] expectedRet = (String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results);
            ArrayUtils.reverse((Object[])expectedRet);
            List<List<Map<String, Object>>> descendingEvents = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : "__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{expectedRet});
            if (this.legacy) {
                for (List<Map<String, Object>> batch : descendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", ((DateTime)event.get("timestamp")).getMillis());
                    }
                }
            } else {
                for (List<Map<String, Object>> batch : descendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                    }
                }
            }
            List<ScanResultValue> descendingExpectedResults = this.toExpected(descendingEvents, this.legacy ? Lists.newArrayList((Object[])new String[]{"__time", this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            ScanQueryRunnerTest.verify(descendingExpectedResults, results);
        }
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndAscendingTimeOrderingCompactedListFormat() {
        Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
        Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
        for (int limit : new int[]{3, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).order(ScanQuery.Order.ASCENDING).limit((long)limit).build();
            Iterable<Object> results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            List<List<Map<String, Object>>> ascendingEvents = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : "__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{(String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results)});
            if (this.legacy) {
                for (List<Map<String, Object>> batch : ascendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", ((DateTime)event.get("timestamp")).getMillis());
                    }
                }
            } else {
                for (List<Map<String, Object>> batch : ascendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                    }
                }
            }
            List<ScanResultValue> ascendingExpectedResults = this.toExpected(ascendingEvents, this.legacy ? Lists.newArrayList((Object[])new String[]{"__time", this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            results = this.compactedListToRow(results);
            ScanQueryRunnerTest.verify(ascendingExpectedResults, results);
        }
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndDescendingTimeOrderingCompactedListFormat() {
        Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
        Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
        for (int limit : new int[]{3, 1}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).order(ScanQuery.Order.DESCENDING).context((Map)ImmutableMap.of((Object)"scanOutermost", (Object)false)).limit((long)limit).build();
            Iterable<Object> results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            Object[] expectedRet = (String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results);
            ArrayUtils.reverse((Object[])expectedRet);
            List<List<Map<String, Object>>> descendingEvents = this.toEvents(new String[]{this.legacy ? this.getTimestampName() + ":TIME" : "__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{expectedRet});
            if (this.legacy) {
                for (List<Map<String, Object>> batch : descendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", ((DateTime)event.get("timestamp")).getMillis());
                    }
                }
            } else {
                for (List<Map<String, Object>> batch : descendingEvents) {
                    for (Map<String, Object> event : batch) {
                        event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                    }
                }
            }
            List<ScanResultValue> descendingExpectedResults = this.toExpected(descendingEvents, this.legacy ? Lists.newArrayList((Object[])new String[]{"__time", this.getTimestampName(), "quality", "index"}) : Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            results = this.compactedListToRow(results);
            ScanQueryRunnerTest.verify(descendingExpectedResults, results);
        }
    }

    @Test
    public void testScanQueryTimeout() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).context((Map)ImmutableMap.of((Object)"timeout", (Object)1)).build();
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        responseContext.add((ResponseContext.BaseKey)ResponseContext.Key.TIMEOUT_AT, (Object)System.currentTimeMillis());
        try {
            this.runner.run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e instanceof QueryTimeoutException));
            Assert.assertEquals((Object)"Query timeout", (Object)((QueryTimeoutException)e).getErrorCode());
        }
    }

    private List<List<Map<String, Object>>> toFullEvents(String[] ... valueSet) {
        return this.toEvents(new String[]{this.getTimestampName() + ":TIME", "market:STRING", "quality:STRING", "qualityLong:LONG", "qualityFloat:FLOAT", "qualityDouble:DOUBLE", "qualityNumericString:STRING", "longNumericNull:LONG", "floatNumericNull:FLOAT", "doubleNumericNull:DOUBLE", "placement:STRING", "placementish:STRINGS", "index:DOUBLE", "partial_null_column:STRING", "expr", "indexMin", "indexFloat", "indexMaxPlusTen", "indexMinFloat", "indexMaxFloat", "quality_uniques"}, valueSet);
    }

    private List<List<Map<String, Object>>> toEvents(String[] dimSpecs, String[] ... valueSet) {
        ArrayList<String> values = new ArrayList<String>();
        for (String[] vSet : valueSet) {
            values.addAll(Arrays.asList(vSet));
        }
        ArrayList<List<Map<String, Object>>> events = new ArrayList<List<Map<String, Object>>>();
        events.add(Lists.newArrayList((Iterable)Iterables.transform(values, input -> {
            HashMap<String, Object> event = new HashMap<String, Object>();
            String[] values1 = input.split("\\t");
            for (int i = 0; i < dimSpecs.length; ++i) {
                if (dimSpecs[i] == null || i >= dimSpecs.length) continue;
                if (dimSpecs[i].equals(EXPR_COLUMN.getOutputName())) {
                    event.put(EXPR_COLUMN.getOutputName(), (Double)event.get("index") * 2.0);
                    continue;
                }
                if (dimSpecs[i].equals("indexMin")) {
                    event.put("indexMin", (Double)event.get("index"));
                    continue;
                }
                if (dimSpecs[i].equals("indexFloat")) {
                    event.put("indexFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                    continue;
                }
                if (dimSpecs[i].equals("indexMaxPlusTen")) {
                    event.put("indexMaxPlusTen", (Double)event.get("index") + 10.0);
                    continue;
                }
                if (dimSpecs[i].equals("indexMinFloat")) {
                    event.put("indexMinFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                    continue;
                }
                if (dimSpecs[i].equals("indexMaxFloat")) {
                    event.put("indexMaxFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                    continue;
                }
                if (dimSpecs[i].equals("quality_uniques")) {
                    HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                    collector.add(Hashing.murmur3_128().hashBytes(StringUtils.toUtf8((String)((String)event.get("quality")))).asBytes());
                    event.put("quality_uniques", collector);
                }
                if (i >= values1.length) continue;
                String[] specs = dimSpecs[i].split(":");
                Object eventVal = specs.length == 1 || specs[1].equals("STRING") ? values1[i] : (specs[1].equals("TIME") ? this.toTimestamp(values1[i]) : (specs[1].equals("FLOAT") ? (values1[i].isEmpty() ? NullHandling.defaultFloatValue() : Float.valueOf(values1[i])) : (specs[1].equals("DOUBLE") ? (values1[i].isEmpty() ? NullHandling.defaultDoubleValue() : Double.valueOf(values1[i])) : (specs[1].equals("LONG") ? (values1[i].isEmpty() ? NullHandling.defaultLongValue() : Long.valueOf(values1[i])) : (specs[1].equals("NULL") ? null : (specs[1].equals("STRINGS") ? Arrays.asList(values1[i].split("\u0001")) : values1[i]))))));
                event.put(specs[0], eventVal);
            }
            return event;
        })));
        return events;
    }

    private Object toTimestamp(String value) {
        if (this.legacy) {
            return DateTimes.of((String)value);
        }
        return DateTimes.of((String)value).getMillis();
    }

    private String getTimestampName() {
        return this.legacy ? "timestamp" : "__time";
    }

    private List<ScanResultValue> toExpected(List<List<Map<String, Object>>> targets, List<String> columns, int offset, int limit) {
        ArrayList expected = Lists.newArrayListWithExpectedSize((int)targets.size());
        for (List<Map<String, Object>> group : targets) {
            ArrayList events = Lists.newArrayListWithExpectedSize((int)limit);
            int end = Math.min(group.size(), offset + limit);
            if (end == 0) {
                end = group.size();
            }
            events.addAll(group.subList(offset, end));
            expected.add(new ScanResultValue(QueryRunnerTestHelper.SEGMENT_ID.toString(), columns, (Object)events));
        }
        return expected;
    }

    public static void verify(Iterable<ScanResultValue> expectedResults, Iterable<ScanResultValue> actualResults) {
        Iterator<ScanResultValue> expectedIter = expectedResults.iterator();
        Iterator<ScanResultValue> actualIter = actualResults.iterator();
        while (expectedIter.hasNext()) {
            ScanResultValue expected = expectedIter.next();
            ScanResultValue actual = actualIter.next();
            Assert.assertEquals((Object)expected.getSegmentId(), (Object)actual.getSegmentId());
            TreeSet exColumns = Sets.newTreeSet((Iterable)expected.getColumns());
            TreeSet acColumns = Sets.newTreeSet((Iterable)actual.getColumns());
            Assert.assertEquals((Object)exColumns, (Object)acColumns);
            Iterator expectedEvts = ((List)expected.getEvents()).iterator();
            Iterator actualEvts = ((List)actual.getEvents()).iterator();
            while (expectedEvts.hasNext()) {
                Map exHolder = (Map)expectedEvts.next();
                Map acHolder = (Map)actualEvts.next();
                for (Map.Entry ex : exHolder.entrySet()) {
                    Object exValue;
                    Object actVal = acHolder.get(ex.getKey());
                    if (actVal instanceof String[]) {
                        actVal = Arrays.asList((String[])actVal);
                    }
                    if ((exValue = ex.getValue()) instanceof Double || exValue instanceof Float) {
                        double expectedDoubleValue = ((Number)exValue).doubleValue();
                        Assert.assertEquals((String)("invalid value for " + (String)ex.getKey()), (double)expectedDoubleValue, (double)((Number)actVal).doubleValue(), (double)(expectedDoubleValue * 1.0E-6));
                        continue;
                    }
                    Assert.assertEquals((String)("invalid value for " + (String)ex.getKey()), ex.getValue(), actVal);
                }
                for (Map.Entry ac : acHolder.entrySet()) {
                    Object exVal = exHolder.get(ac.getKey());
                    Object actVal = ac.getValue();
                    if (actVal instanceof String[]) {
                        actVal = Arrays.asList((String[])actVal);
                    }
                    if (exVal instanceof Double || exVal instanceof Float) {
                        double exDoubleValue = ((Number)exVal).doubleValue();
                        Assert.assertEquals((String)("invalid value for " + (String)ac.getKey()), (double)exDoubleValue, (double)((Number)actVal).doubleValue(), (double)(exDoubleValue * 1.0E-6));
                        continue;
                    }
                    Assert.assertEquals((String)("invalid value for " + (String)ac.getKey()), exVal, actVal);
                }
            }
            if (!actualEvts.hasNext()) continue;
            throw new ISE("This event iterator should be exhausted!", new Object[0]);
        }
        if (actualIter.hasNext()) {
            throw new ISE("This iterator should be exhausted!", new Object[0]);
        }
    }

    private static Iterable<ScanResultValue> populateNullColumnAtLastForQueryableIndexCase(Iterable<ScanResultValue> results, String columnName) {
        ScanResultValue value;
        List columns;
        Iterator<ScanResultValue> iterator = results.iterator();
        while (iterator.hasNext() && !(columns = (value = iterator.next()).getColumns()).contains(columnName)) {
            columns.add(columnName);
        }
        return results;
    }

    private Iterable<ScanResultValue> compactedListToRow(Iterable<ScanResultValue> results) {
        return Lists.newArrayList((Iterable)Iterables.transform(results, (Function)new Function<ScanResultValue, ScanResultValue>(){

            public ScanResultValue apply(ScanResultValue input) {
                ArrayList mapEvents = new ArrayList();
                List events = (List)input.getEvents();
                for (Object event : events) {
                    Iterator compactedEventIter = ((List)event).iterator();
                    LinkedHashMap mapEvent = new LinkedHashMap();
                    for (String column : input.getColumns()) {
                        mapEvent.put(column, compactedEventIter.next());
                    }
                    mapEvents.add(mapEvent);
                }
                return new ScanResultValue(input.getSegmentId(), input.getColumns(), mapEvents);
            }
        }));
    }
}

