/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumns;
import org.junit.Assert;
import org.junit.Test;

public class ScanQuerySpecTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerialization() throws Exception {
        String legacy = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\"],\"limit\":3,\"context\":null}";
        String current = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"virtualColumns\":[],\"resultFormat\":\"list\",\"batchSize\":20480,\"limit\":3,\"order\":\"none\",\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\"],\"legacy\":null,\"context\":null,\"descending\":false,\"granularity\":{\"type\":\"all\"}}";
        ScanQuery query = new ScanQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), VirtualColumns.EMPTY, ScanQuery.ResultFormat.RESULT_FORMAT_LIST, 0, 0L, 3L, ScanQuery.Order.NONE, null, Arrays.asList("market", "quality", "index"), null, null);
        String actual = JSON_MAPPER.writeValueAsString((Object)query);
        Assert.assertEquals((Object)current, (Object)actual);
        Assert.assertEquals((Object)query, (Object)JSON_MAPPER.readValue(actual, ScanQuery.class));
        Assert.assertEquals((Object)query, (Object)JSON_MAPPER.readValue(legacy, ScanQuery.class));
    }

    @Test
    public void testSerializationLegacyString() throws Exception {
        ScanQuery query = new ScanQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), VirtualColumns.EMPTY, ScanQuery.ResultFormat.RESULT_FORMAT_LIST, 0, 1L, 3L, ScanQuery.Order.NONE, null, Arrays.asList("market", "quality", "index"), null, null);
        String serialized = JSON_MAPPER.writeValueAsString((Object)query);
        ScanQuery deserialized = (ScanQuery)JSON_MAPPER.readValue(serialized, Query.class);
        Assert.assertEquals((Object)query, (Object)deserialized);
    }
}

