/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.cartesian(Arrays.asList(false, true));
    }

    public TimeseriesQueryTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testQuerySerialization() throws IOException {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testGetRequiredColumns() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("index", "\"fieldFromVirtualColumn\"", ValueType.LONG, ExprMacroTable.nil())}).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.INDEX_LONG_MAX, new LongSumAggregatorFactory("beep", "aField")}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"fieldFromVirtualColumn", (Object)"aField"), (Object)query.getRequiredColumns());
    }
}

