/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.dimension.LegacyDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TopNQueryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testQuerySerdeWithLookupExtractionFn() throws IOException {
        TopNQuery expectedQuery = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), true, null, Boolean.valueOf(false), Boolean.valueOf(false)))).metric((TopNMetricSpec)new NumericTopNMetricSpec("index")).threshold(2).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC.getIntervals()).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).build();
        String str = JSON_MAPPER.writeValueAsString((Object)expectedQuery);
        Assert.assertEquals((Object)expectedQuery, (Object)JSON_MAPPER.readValue(str, TopNQuery.class));
    }

    @Test
    public void testQuerySerdeWithAlphaNumericTopNMetricSpec() throws IOException {
        TopNQuery expectedQuery = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new LegacyDimensionSpec((Object)"market")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.ALPHANUMERIC)).threshold(2).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC.getIntervals()).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).build();
        String jsonQuery = "{\n  \"queryType\": \"topN\",\n  \"dataSource\": \"testing\",\n  \"dimension\": \"market\",\n  \"threshold\": 2,\n  \"metric\": {\n    \"type\": \"dimension\",\n    \"ordering\": \"alphanumeric\"\n   },\n  \"granularity\": \"all\",\n  \"aggregations\": [\n    {\n      \"type\": \"count\",\n      \"name\": \"rows\"\n    }\n  ],\n  \"intervals\": [\n    \"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"\n  ]\n}";
        TopNQuery actualQuery = (TopNQuery)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString(JSON_MAPPER.readValue(jsonQuery, TopNQuery.class)), TopNQuery.class);
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    @Test
    public void testQueryNullDimensionSpec() throws IOException {
        this.expectedException.expectMessage("dimensionSpec can't be null");
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        JSON_MAPPER.readValue(json, Query.class);
    }

    @Test
    public void testQueryZeroThreshold() throws IOException {
        this.expectedException.expectMessage("Threshold cannot be equal to 0.");
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).metric("index").dimension((DimensionSpec)new LegacyDimensionSpec((Object)"market")).threshold(0).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        JSON_MAPPER.readValue(json, Query.class);
    }

    @Test
    public void testQueryNullMetric() throws IOException {
        this.expectedException.expectMessage("must specify a metric");
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new LegacyDimensionSpec((Object)"market")).threshold(2).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        JSON_MAPPER.readValue(json, Query.class);
    }

    @Test
    public void testGetRequiredColumns() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v", "\"other\"", ValueType.STRING, ExprMacroTable.nil())}).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"v")).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).granularity(QueryRunnerTestHelper.DAY_GRAN).postAggregators((Collection)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).metric((TopNMetricSpec)new NumericTopNMetricSpec("idx")).threshold(100).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"other", (Object)"index"), (Object)query.getRequiredColumns());
    }
}

