/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.io.IOException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CloserRule
implements TestRule {
    private final boolean throwException;
    private static final Logger LOG = new Logger(CloserRule.class);
    private final Closer closer = Closer.create();

    public CloserRule(boolean throwException) {
        this.throwException = throwException;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                catch (Throwable e) {
                    throw CloserRule.this.closer.rethrow(e);
                }
                finally {
                    CloserRule.this.closer.close();
                }
            }
        };
    }

    public <T extends Closeable> T closeLater(final T closeable) {
        this.closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                if (CloserRule.this.throwException) {
                    closeable.close();
                } else {
                    try {
                        closeable.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e, "Error closing [%s]", new Object[]{closeable});
                    }
                }
            }
        });
        return closeable;
    }
}

