/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.File;
import java.io.IOException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.jackson.SegmentizerModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CustomSegmentizerFactoryTest
extends InitializedNullHandlingTest {
    private static ObjectMapper JSON_MAPPER;
    private static IndexIO INDEX_IO;
    private static IndexMerger INDEX_MERGER;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @BeforeClass
    public static void setup() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerModule((Module)new SegmentizerModule());
        mapper.registerSubtypes(new NamedType[]{new NamedType(CustomSegmentizerFactory.class, "customSegmentFactory")});
        IndexIO indexIO = new IndexIO((ObjectMapper)mapper, () -> 0);
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper).addValue(IndexIO.class, (Object)indexIO).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
        JSON_MAPPER = mapper;
        INDEX_IO = indexIO;
        INDEX_MERGER = new IndexMergerV9((ObjectMapper)mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    }

    @Test
    public void testDefaultSegmentizerPersist() throws IOException {
        IncrementalIndex data = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv");
        File segment = new File(this.temporaryFolder.newFolder(), "segment");
        File persisted = INDEX_MERGER.persist(data, Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z"), segment, new IndexSpec(null, null, null, null, null), null);
        File factoryJson = new File(persisted, "factory.json");
        Assert.assertTrue((boolean)factoryJson.exists());
        SegmentizerFactory factory = (SegmentizerFactory)JSON_MAPPER.readValue(factoryJson, SegmentizerFactory.class);
        Assert.assertTrue((boolean)(factory instanceof MMappedQueryableSegmentizerFactory));
    }

    @Test
    public void testCustomSegmentizerPersist() throws IOException {
        IncrementalIndex data = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv");
        File segment = new File(this.temporaryFolder.newFolder(), "segment");
        File persisted = INDEX_MERGER.persist(data, Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z"), segment, new IndexSpec(null, null, null, null, (SegmentizerFactory)new CustomSegmentizerFactory()), null);
        File factoryJson = new File(persisted, "factory.json");
        Assert.assertTrue((boolean)factoryJson.exists());
        SegmentizerFactory factory = (SegmentizerFactory)JSON_MAPPER.readValue(factoryJson, SegmentizerFactory.class);
        Assert.assertTrue((boolean)(factory instanceof CustomSegmentizerFactory));
    }

    private static class CustomSegmentizerFactory
    implements SegmentizerFactory {
        private CustomSegmentizerFactory() {
        }

        public Segment factorize(DataSegment segment, File parentDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws SegmentLoadingException {
            try {
                return new QueryableIndexSegment(INDEX_IO.loadIndex(parentDir, lazy, loadFailed), segment.getId());
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
            }
        }
    }
}

