/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.data.IncrementalIndexTest;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IndexMergerRollupTest
extends InitializedNullHandlingTest {
    private IndexMerger indexMerger;
    private IndexIO indexIO;
    private IndexSpec indexSpec;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() {
        this.indexMerger = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.indexIO = TestHelper.getTestIndexIO();
        this.indexSpec = new IndexSpec();
    }

    private void testStringFirstLastRollup(AggregatorFactory[] aggregatorFactories) throws Exception {
        List<Map> eventsList = Arrays.asList(new HashMap<String, Object>(){
            {
                this.put("d", "d1");
                this.put("m", "m1");
            }
        }, new HashMap<String, Object>(){
            {
                this.put("d", "d1");
                this.put("m", "m2");
            }
        });
        File tempDir = this.temporaryFolder.newFolder();
        ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>();
        Instant time = Instant.now();
        for (Map events : eventsList) {
            IncrementalIndex toPersist = IncrementalIndexTest.createIndex(aggregatorFactories);
            toPersist.add((InputRow)new MapBasedInputRow(time.toEpochMilli(), (List)ImmutableList.of((Object)"d"), events));
            indexes.add(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
        }
        File indexFile = this.indexMerger.mergeQueryableIndex(indexes, true, aggregatorFactories, tempDir, this.indexSpec, null, -1);
        try (QueryableIndex mergedIndex = this.indexIO.loadIndex(indexFile);){
            Assert.assertEquals((String)"Number of rows should be 1", (long)1L, (long)mergedIndex.getNumRows());
        }
    }

    @Test
    public void testStringFirstRollup() throws Exception {
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new StringFirstAggregatorFactory("m", "m", Integer.valueOf(1024))};
        this.testStringFirstLastRollup(aggregatorFactories);
    }

    @Test
    public void testStringLastRollup() throws Exception {
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new StringLastAggregatorFactory("m", "m", Integer.valueOf(1024))};
        this.testStringFirstLastRollup(aggregatorFactories);
    }
}

