/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class QueryableIndexStorageAdapterTest {

    @RunWith(value=Parameterized.class)
    public static class DimensionDictionarySelectorTest
    extends InitializedNullHandlingTest {
        private final boolean vectorize;
        private DimensionDictionarySelector qualitySelector;
        private DimensionDictionarySelector placementishSelector;
        private DimensionDictionarySelector partialNullSelector;
        private Closer closer = Closer.create();

        @Parameterized.Parameters(name="vectorize = {0}")
        public static Collection<?> constructorFeeder() {
            return Arrays.asList({false}, {true});
        }

        public DimensionDictionarySelectorTest(boolean vectorize) {
            this.vectorize = vectorize;
        }

        @Before
        public void setUp() {
            QueryableIndex index = TestIndex.getMMappedTestIndex();
            QueryableIndexStorageAdapter adapter = new QueryableIndexStorageAdapter(index);
            if (this.vectorize) {
                VectorCursor cursor = (VectorCursor)this.closer.register((Closeable)adapter.makeVectorCursor(null, Intervals.ETERNITY, VirtualColumns.EMPTY, false, 512, null));
                VectorColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                this.qualitySelector = columnSelectorFactory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"quality"));
                this.placementishSelector = columnSelectorFactory.makeMultiValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"placementish"));
                this.partialNullSelector = columnSelectorFactory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"partial_null_column"));
            } else {
                Sequence cursors = adapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
                Yielder yielder = (Yielder)this.closer.register((Closeable)Yielders.each((Sequence)cursors));
                Cursor cursor = (Cursor)yielder.get();
                ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                this.qualitySelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"quality"));
                this.placementishSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"placementish"));
                this.partialNullSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"partial_null_column"));
            }
        }

        @After
        public void tearDown() throws IOException {
            this.closer.close();
        }

        @Test
        public void test_getCardinality_quality() {
            Assert.assertEquals((long)9L, (long)this.qualitySelector.getValueCardinality());
        }

        @Test
        public void test_getCardinality_placementish() {
            Assert.assertEquals((long)9L, (long)this.placementishSelector.getValueCardinality());
        }

        @Test
        public void test_getCardinality_partialNullColumn() {
            Assert.assertEquals((long)2L, (long)this.partialNullSelector.getValueCardinality());
        }

        @Test
        public void test_lookupName_quality() {
            Assert.assertEquals((Object)"automotive", (Object)this.qualitySelector.lookupName(0));
            Assert.assertEquals((Object)"business", (Object)this.qualitySelector.lookupName(1));
            Assert.assertEquals((Object)"entertainment", (Object)this.qualitySelector.lookupName(2));
            Assert.assertEquals((Object)"health", (Object)this.qualitySelector.lookupName(3));
            Assert.assertEquals((Object)"mezzanine", (Object)this.qualitySelector.lookupName(4));
            Assert.assertEquals((Object)"news", (Object)this.qualitySelector.lookupName(5));
            Assert.assertEquals((Object)"premium", (Object)this.qualitySelector.lookupName(6));
            Assert.assertEquals((Object)"technology", (Object)this.qualitySelector.lookupName(7));
            Assert.assertEquals((Object)"travel", (Object)this.qualitySelector.lookupName(8));
        }

        @Test
        public void test_lookupName_placementish() {
            Assert.assertEquals((Object)"a", (Object)this.placementishSelector.lookupName(0));
            Assert.assertEquals((Object)"b", (Object)this.placementishSelector.lookupName(1));
            Assert.assertEquals((Object)"e", (Object)this.placementishSelector.lookupName(2));
            Assert.assertEquals((Object)"h", (Object)this.placementishSelector.lookupName(3));
            Assert.assertEquals((Object)"m", (Object)this.placementishSelector.lookupName(4));
            Assert.assertEquals((Object)"n", (Object)this.placementishSelector.lookupName(5));
            Assert.assertEquals((Object)"p", (Object)this.placementishSelector.lookupName(6));
            Assert.assertEquals((Object)"preferred", (Object)this.placementishSelector.lookupName(7));
            Assert.assertEquals((Object)"t", (Object)this.placementishSelector.lookupName(8));
        }

        @Test
        public void test_lookupName_partialNull() {
            Assert.assertNull((Object)this.partialNullSelector.lookupName(0));
            Assert.assertEquals((Object)"value", (Object)this.partialNullSelector.lookupName(1));
        }

        @Test
        public void test_lookupNameUtf8_quality() {
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"automotive")), (Object)this.qualitySelector.lookupNameUtf8(0));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"business")), (Object)this.qualitySelector.lookupNameUtf8(1));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"entertainment")), (Object)this.qualitySelector.lookupNameUtf8(2));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"health")), (Object)this.qualitySelector.lookupNameUtf8(3));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"mezzanine")), (Object)this.qualitySelector.lookupNameUtf8(4));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"news")), (Object)this.qualitySelector.lookupNameUtf8(5));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"premium")), (Object)this.qualitySelector.lookupNameUtf8(6));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"technology")), (Object)this.qualitySelector.lookupNameUtf8(7));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"travel")), (Object)this.qualitySelector.lookupNameUtf8(8));
        }

        @Test
        public void test_lookupNameUtf8_placementish() {
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"a")), (Object)this.placementishSelector.lookupNameUtf8(0));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"b")), (Object)this.placementishSelector.lookupNameUtf8(1));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"e")), (Object)this.placementishSelector.lookupNameUtf8(2));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"h")), (Object)this.placementishSelector.lookupNameUtf8(3));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"m")), (Object)this.placementishSelector.lookupNameUtf8(4));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"n")), (Object)this.placementishSelector.lookupNameUtf8(5));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"p")), (Object)this.placementishSelector.lookupNameUtf8(6));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"preferred")), (Object)this.placementishSelector.lookupNameUtf8(7));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"t")), (Object)this.placementishSelector.lookupNameUtf8(8));
        }

        @Test
        public void test_lookupNameUtf8_partialNull() {
            Assert.assertNull((Object)this.partialNullSelector.lookupNameUtf8(0));
            Assert.assertEquals((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value")), (Object)this.partialNullSelector.lookupNameUtf8(1));
        }

        @Test
        public void test_lookupNameUtf8_buffersAreNotShared() {
            Assert.assertNotSame((Object)this.qualitySelector.lookupNameUtf8(0), (Object)this.qualitySelector.lookupNameUtf8(0));
        }

        @Test
        public void test_supportsLookupNameUtf8_quality() {
            Assert.assertTrue((boolean)this.partialNullSelector.supportsLookupNameUtf8());
        }

        @Test
        public void test_supportsLookupNameUtf8_placementish() {
            Assert.assertTrue((boolean)this.partialNullSelector.supportsLookupNameUtf8());
        }

        @Test
        public void test_supportsLookupNameUtf8_partialNull() {
            Assert.assertTrue((boolean)this.partialNullSelector.supportsLookupNameUtf8());
        }
    }
}

