/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class RowBasedColumnSelectorFactoryTest
extends InitializedNullHandlingTest {
    private static final String STRING_COLUMN_NAME = "string";
    private static final String LONG_COLUMN_NAME = "long";
    private static final String FLOAT_COLUMN_NAME = "float";
    private static final String DOUBLE_COLUMN_NAME = "double";
    private static final String COMPLEX_COLUMN_NAME = "complex";
    private static final String DOUBLE_ARRAY_COLUMN_NAME = "double_array";
    private static final String LONG_ARRAY_COLUMN_NAME = "long_array";
    private static final String STRING_ARRAY_COLUMN_NAME = "string_array";
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("__time", ValueType.LONG).add("string", ValueType.STRING).add("long", ValueType.LONG).add("float", ValueType.FLOAT).add("double", ValueType.DOUBLE).add("complex", ValueType.COMPLEX).add("double_array", ValueType.DOUBLE_ARRAY).add("long_array", ValueType.LONG_ARRAY).add("string_array", ValueType.STRING_ARRAY).build();

    @Test
    public void testCapabilitiesTime() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)"__time");
        Assert.assertEquals((Object)ValueType.LONG, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesString() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)STRING_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesLong() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)LONG_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.LONG, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesFloat() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)FLOAT_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesDouble() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)DOUBLE_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesComplex() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)COMPLEX_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.COMPLEX, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesDoubleArray() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)DOUBLE_ARRAY_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.DOUBLE_ARRAY, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesLongArray() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)LONG_ARRAY_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.LONG_ARRAY, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesStringArray() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)STRING_ARRAY_COLUMN_NAME);
        Assert.assertEquals((Object)ValueType.STRING_ARRAY, (Object)caps.getType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
    }

    @Test
    public void testCapabilitiesUnknownColumn() {
        ColumnCapabilities caps = RowBasedColumnSelectorFactory.getColumnCapabilities((RowSignature)ROW_SIGNATURE, (String)"wat");
        Assert.assertNull((Object)caps);
    }
}

