/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.druid.segment.FloatWrappingDimensionSelector;
import org.apache.druid.segment.LongWrappingDimensionSelector;
import org.apache.druid.segment.TestNullableDoubleColumnSelector;
import org.apache.druid.segment.TestNullableFloatColumnSelector;
import org.apache.druid.segment.TestNullableLongColumnSelector;
import org.junit.Assert;
import org.junit.Test;

public class WrappingDimensionSelectorTest {
    @Test
    public void testLongWrappingDimensionSelector() {
        Long[] vals = new Long[]{24L, null, 50L, 0L, -60L};
        TestNullableLongColumnSelector lngSelector = new TestNullableLongColumnSelector(vals);
        LongWrappingDimensionSelector lngWrapSelector = new LongWrappingDimensionSelector((BaseLongColumnValueSelector)lngSelector, null);
        Assert.assertEquals((long)24L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"24", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        if (NullHandling.sqlCompatible()) {
            Assert.assertTrue((boolean)lngSelector.isNull());
        } else {
            Assert.assertEquals((long)0L, (long)lngSelector.getLong());
        }
        lngSelector.increment();
        Assert.assertEquals((long)50L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"50", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)0L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"0", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)-60L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"-60", (Object)lngWrapSelector.getValue());
    }

    @Test
    public void testDoubleWrappingDimensionSelector() {
        Double[] vals = new Double[]{32.0, null, 5.0, 0.0, -45.0};
        TestNullableDoubleColumnSelector dblSelector = new TestNullableDoubleColumnSelector(vals);
        DoubleWrappingDimensionSelector dblWrapSelector = new DoubleWrappingDimensionSelector((BaseDoubleColumnValueSelector)dblSelector, null);
        Assert.assertEquals((double)32.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"32.0", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        if (NullHandling.sqlCompatible()) {
            Assert.assertTrue((boolean)dblSelector.isNull());
        } else {
            Assert.assertEquals((double)0.0, (double)dblSelector.getDouble(), (double)0.0);
        }
        dblSelector.increment();
        Assert.assertEquals((double)5.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"5.0", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)0.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"0.0", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)-45.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"-45.0", (Object)dblWrapSelector.getValue());
    }

    @Test
    public void testFloatWrappingDimensionSelector() {
        Float[] vals = new Float[]{Float.valueOf(32.0f), null, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(-45.0f)};
        TestNullableFloatColumnSelector flSelector = new TestNullableFloatColumnSelector(vals);
        FloatWrappingDimensionSelector flWrapSelector = new FloatWrappingDimensionSelector((BaseFloatColumnValueSelector)flSelector, null);
        Assert.assertEquals((float)32.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"32.0", (Object)flWrapSelector.getValue());
        flSelector.increment();
        if (NullHandling.sqlCompatible()) {
            Assert.assertTrue((boolean)flSelector.isNull());
        } else {
            Assert.assertEquals((float)0.0f, (float)flSelector.getFloat(), (float)0.0f);
        }
        flSelector.increment();
        Assert.assertEquals((float)5.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"5.0", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)0.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"0.0", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)-45.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"-45.0", (Object)flWrapSelector.getValue());
    }
}

