/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.FilterTestUtils;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.filter.TrueFilter;
import org.apache.druid.segment.filter.cnf.CalciteCnfHelper;
import org.apache.druid.segment.filter.cnf.HiveCnfHelper;
import org.junit.Assert;
import org.junit.Test;

public class FilterCnfConversionTest {
    @Test
    public void testPushDownNot() {
        NotFilter filter = FilterTestUtils.not((Filter)FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "1"), FilterTestUtils.selector("col2", "2"), FilterTestUtils.not((Filter)FilterTestUtils.selector("col3", "3"))}));
        OrFilter expected = FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col1", "1")), FilterTestUtils.not((Filter)FilterTestUtils.selector("col2", "2")), FilterTestUtils.selector("col3", "3")});
        Filter pushedDown = HiveCnfHelper.pushDownNot((Filter)filter);
        this.assertFilter((Filter)filter, (Filter)expected, pushedDown);
    }

    @Test
    public void testPushDownNotLeafNot() {
        AndFilter filter = FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "1"), FilterTestUtils.selector("col2", "2"), FilterTestUtils.not((Filter)FilterTestUtils.selector("col3", "3"))});
        Filter pushedDown = HiveCnfHelper.pushDownNot((Filter)filter);
        this.assertFilter((Filter)filter, (Filter)filter, pushedDown);
    }

    @Test
    public void testFlatten() {
        AndFilter filter = FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "1"), FilterTestUtils.selector("col2", "2")})}), FilterTestUtils.selector("col3", "3")});
        AndFilter expected = FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "1"), FilterTestUtils.selector("col2", "2"), FilterTestUtils.selector("col3", "3")});
        Filter flattened = HiveCnfHelper.flatten((Filter)filter);
        this.assertFilter((Filter)filter, (Filter)expected, flattened);
    }

    @Test
    public void testFlattenUnflattenable() {
        AndFilter filter = FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "1"), FilterTestUtils.selector("col2", "2")}), FilterTestUtils.selector("col3", "3")});
        Filter flattened = HiveCnfHelper.flatten((Filter)filter);
        this.assertFilter((Filter)filter, (Filter)filter, flattened);
    }

    @Test
    public void testToCnfWithMuchReducibleFilter() {
        AndFilter muchReducible = FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1")})})}), FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1")})})}), FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1")})})}), FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2"), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")}), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col2", "val2"), FilterTestUtils.selector("col1", "val1")})})});
        AndFilter expected = FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")});
        Filter cnf = Filters.toCnf((Filter)muchReducible);
        this.assertFilter((Filter)muchReducible, (Filter)expected, cnf);
    }

    @Test
    public void testToNormalizedOrClausesWithMuchReducibleFilter() {
        AndFilter muchReducible = FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1")})})}), FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1")})})}), FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1")})})}), FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2"), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")}), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col2", "val2"), FilterTestUtils.selector("col1", "val1")})})});
        ImmutableList expected = ImmutableList.of((Object)FilterTestUtils.selector("col1", "val1"), (Object)FilterTestUtils.selector("col2", "val2"));
        List normalizedOrClauses = Filters.toNormalizedOrClauses((Filter)muchReducible);
        Assert.assertEquals((Object)expected, (Object)normalizedOrClauses);
    }

    @Test
    public void testToCnfWithComplexFilterIncludingNotAndOr() {
        AndFilter filter = FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")}), FilterTestUtils.not((Filter)FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col4", "val4"), FilterTestUtils.selector("col5", "val5")}))}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col2", "val2"), FilterTestUtils.selector("col4", "val4"), FilterTestUtils.selector("col5", "val5")})), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col3", "val3")})}), FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val22"), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.not((Filter)FilterTestUtils.selector("col1", "val11"))}), FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val22"), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.not((Filter)FilterTestUtils.selector("col1", "val11"))})});
        AndFilter expected = FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col1", "val1")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col2", "val2")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col2", "val2")), FilterTestUtils.selector("col1", "val1")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.selector("col1", "val1")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col1", "val1")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col2", "val2")), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val22"), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.not((Filter)FilterTestUtils.selector("col1", "val11"))});
        Filter cnf = Filters.toCnf((Filter)filter);
        this.assertFilter((Filter)filter, (Filter)expected, cnf);
    }

    @Test
    public void testToNormalizedOrClausesWithComplexFilterIncludingNotAndOr() {
        AndFilter filter = FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")}), FilterTestUtils.not((Filter)FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col4", "val4"), FilterTestUtils.selector("col5", "val5")}))}), FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col2", "val2"), FilterTestUtils.selector("col4", "val4"), FilterTestUtils.selector("col5", "val5")})), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col3", "val3")})}), FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val22"), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.not((Filter)FilterTestUtils.selector("col1", "val11"))}), FilterTestUtils.and(new Filter[]{FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val22"), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.not((Filter)FilterTestUtils.selector("col1", "val11"))})});
        ImmutableList expected = ImmutableList.of((Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col1", "val1")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col2", "val2")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col2", "val2")), FilterTestUtils.selector("col1", "val1")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.selector("col1", "val1")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col1", "val1")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col2", "val2")), FilterTestUtils.selector("col3", "val3")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col4", "val4")), FilterTestUtils.selector("col3", "val3")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.not((Filter)FilterTestUtils.selector("col5", "val5")), FilterTestUtils.selector("col3", "val3")}), (Object)FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val22"), FilterTestUtils.selector("col3", "val3")}), (Object)FilterTestUtils.not((Filter)FilterTestUtils.selector("col1", "val11")));
        List normalizedOrClauses = Filters.toNormalizedOrClauses((Filter)filter);
        Assert.assertEquals((Object)expected, (Object)normalizedOrClauses);
    }

    @Test
    public void testToCnfCollapsibleBigFilter() {
        ArrayList<AndFilter> ands = new ArrayList<AndFilter>();
        ArrayList<SelectorFilter> ors = new ArrayList<SelectorFilter>();
        for (int i = 0; i < 12; ++i) {
            ands.add(FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col3", "val3"), FilterTestUtils.selector("col4", "val4"), FilterTestUtils.selector("col5", StringUtils.format((String)"val%d", (Object[])new Object[]{i}))}));
            ors.add(FilterTestUtils.selector("col5", StringUtils.format((String)"val%d", (Object[])new Object[]{i})));
        }
        AndFilter bigFilter = FilterTestUtils.and(new Filter[]{new OrFilter(ands), FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")});
        AndFilter expectedCnf = FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col3", "val3"), FilterTestUtils.selector("col4", "val4"), new OrFilter(ors), FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")});
        Filter cnf = Filters.toCnf((Filter)bigFilter);
        this.assertFilter((Filter)bigFilter, (Filter)expectedCnf, cnf);
    }

    @Test
    public void testPullOrOnlyFilter() {
        OrFilter filter = FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2"), FilterTestUtils.selector("col3", "val3")});
        this.assertFilter((Filter)filter, (Filter)filter, CalciteCnfHelper.pull((Filter)filter));
    }

    @Test
    public void testPullNotPullableFilter() {
        OrFilter filter = FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")}), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col3", "val3"), FilterTestUtils.selector("col4", "val4")}), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col5", "val5"), FilterTestUtils.selector("col6", "val6")}), FilterTestUtils.selector("col7", "val7")});
        this.assertFilter((Filter)filter, (Filter)filter, CalciteCnfHelper.pull((Filter)filter));
    }

    @Test
    public void testToCnfFilterThatPullCannotConvertToCnfProperly() {
        OrFilter filter = FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")}), FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col3", "val3"), FilterTestUtils.selector("col4", "val4")})});
        AndFilter expectedCnf = FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col2", "val2"), FilterTestUtils.selector("col3", "val3")}), FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col2", "val2"), FilterTestUtils.selector("col4", "val4")})});
        this.assertFilter((Filter)filter, (Filter)expectedCnf, Filters.toCnf((Filter)filter));
    }

    @Test
    public void testToNormalizedOrClausesNonAndFilterShouldReturnSingleton() {
        OrFilter filter = FilterTestUtils.or(new Filter[]{FilterTestUtils.selector("col1", "val1"), FilterTestUtils.selector("col2", "val2")});
        List<OrFilter> expected = Collections.singletonList(filter);
        List normalizedOrClauses = Filters.toNormalizedOrClauses((Filter)filter);
        Assert.assertEquals(expected, (Object)normalizedOrClauses);
    }

    @Test
    public void testTrueFalseFilterRequiredColumnRewrite() {
        Assert.assertTrue((boolean)TrueFilter.instance().supportsRequiredColumnRewrite());
        Assert.assertTrue((boolean)FalseFilter.instance().supportsRequiredColumnRewrite());
        Assert.assertEquals((Object)TrueFilter.instance(), (Object)TrueFilter.instance().rewriteRequiredColumns((Map)ImmutableMap.of()));
        Assert.assertEquals((Object)FalseFilter.instance(), (Object)FalseFilter.instance().rewriteRequiredColumns((Map)ImmutableMap.of()));
    }

    private void assertFilter(Filter original, Filter expectedConverted, Filter actualConverted) {
        this.assertEquivalent(original, expectedConverted);
        Assert.assertEquals((Object)expectedConverted, (Object)actualConverted);
    }

    private void assertEquivalent(Filter f1, Filter f2) {
        Set<SelectorFilter> s1 = this.searchForSelectors(f1);
        Set<SelectorFilter> s2 = this.searchForSelectors(f2);
        Assert.assertEquals(s1, s2);
        ArrayList<SelectorFilter> selectorFilters = new ArrayList<SelectorFilter>(s1);
        List<Map<SelectorFilter, Boolean>> truthValues = this.populate(selectorFilters, selectorFilters.size() - 1);
        for (Map<SelectorFilter, Boolean> truthValue : truthValues) {
            Assert.assertEquals((Object)this.evaluateFilterWith(f1, truthValue), (Object)this.evaluateFilterWith(f2, truthValue));
        }
    }

    private List<Map<SelectorFilter, Boolean>> populate(List<SelectorFilter> selectorFilters, int cursor) {
        ArrayList<HashMap<SelectorFilter, Boolean>> populateTrue;
        ArrayList<HashMap<SelectorFilter, Boolean>> populateFalse;
        if (cursor == 0) {
            HashMap<SelectorFilter, Boolean> mapForFalse = new HashMap<SelectorFilter, Boolean>();
            HashMap<SelectorFilter, Boolean> hashMap = new HashMap<SelectorFilter, Boolean>();
            for (SelectorFilter eachFilter : selectorFilters) {
                mapForFalse.put(eachFilter, false);
                hashMap.put(eachFilter, false);
            }
            populateFalse = new ArrayList();
            populateFalse.add(mapForFalse);
            populateTrue = new ArrayList();
            populateTrue.add(hashMap);
        } else {
            List<Map<SelectorFilter, Boolean>> populated = this.populate(selectorFilters, cursor - 1);
            populateFalse = new ArrayList<HashMap<SelectorFilter, Boolean>>(populated.size());
            populateTrue = new ArrayList<HashMap<SelectorFilter, Boolean>>(populated.size());
            Iterator<Map<SelectorFilter, Boolean>> iterator = populated.iterator();
            while (iterator.hasNext()) {
                Map<SelectorFilter, Boolean> eachMap = iterator.next();
                populateFalse.add(new HashMap<SelectorFilter, Boolean>(eachMap));
                populateTrue.add(new HashMap<SelectorFilter, Boolean>(eachMap));
            }
        }
        for (Map map : populateTrue) {
            map.put(selectorFilters.get(cursor), true);
        }
        ArrayList<Map<SelectorFilter, Boolean>> allPopulated = new ArrayList<Map<SelectorFilter, Boolean>>(populateFalse);
        allPopulated.addAll(populateTrue);
        return allPopulated;
    }

    private Set<SelectorFilter> searchForSelectors(Filter filter) {
        HashSet<SelectorFilter> found = new HashSet<SelectorFilter>();
        this.visitSelectorFilters(filter, selectorFilter -> {
            found.add((SelectorFilter)selectorFilter);
            return selectorFilter;
        });
        return found;
    }

    private boolean evaluateFilterWith(Filter filter, Map<SelectorFilter, Boolean> values) {
        Filter rewrittenFilter = this.visitSelectorFilters(filter, selectorFilter -> {
            Boolean truth = (Boolean)values.get(selectorFilter);
            if (truth == null) {
                throw new ISE("Can't find truth value for selectorFilter[%s]", new Object[]{selectorFilter});
            }
            return truth != false ? TrueFilter.instance() : FalseFilter.instance();
        });
        return rewrittenFilter.makeMatcher(new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public ColumnValueSelector makeColumnValueSelector(String columnName) {
                return null;
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return null;
            }
        }).matches();
    }

    private Filter visitSelectorFilters(Filter filter, Function<SelectorFilter, Filter> visitAction) {
        if (filter instanceof AndFilter) {
            ArrayList<Filter> newChildren = new ArrayList<Filter>();
            for (Filter child : ((AndFilter)filter).getFilters()) {
                newChildren.add(this.visitSelectorFilters(child, visitAction));
            }
            return new AndFilter(newChildren);
        }
        if (filter instanceof OrFilter) {
            ArrayList<Filter> newChildren = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)filter).getFilters()) {
                newChildren.add(this.visitSelectorFilters(child, visitAction));
            }
            return new OrFilter(newChildren);
        }
        if (filter instanceof NotFilter) {
            Filter child = ((NotFilter)filter).getBaseFilter();
            return new NotFilter(this.visitSelectorFilters(child, visitAction));
        }
        if (filter instanceof SelectorFilter) {
            return visitAction.apply((SelectorFilter)filter);
        }
        return filter;
    }
}

