/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.segment.IntIteratorUtils;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class FiltersTest
extends InitializedNullHandlingTest {
    @Test
    public void testEstimateSelectivityOfBitmapList() {
        int bitmapNum = 100;
        ArrayList bitmaps = Lists.newArrayListWithCapacity((int)100);
        BitmapIndex bitmapIndex = FiltersTest.makeNonOverlappedBitmapIndexes(100, bitmaps);
        double estimated = Filters.estimateSelectivity((BitmapIndex)bitmapIndex, (IntList)IntIteratorUtils.toIntList((IntIterator)IntIterators.fromTo((int)0, (int)100)), (long)10000L);
        double expected = 0.1;
        Assert.assertEquals((double)0.1, (double)estimated, (double)1.0E-5);
    }

    private static BitmapIndex getBitmapIndex(final List<ImmutableBitmap> bitmapList) {
        return new BitmapIndex(){

            public int getCardinality() {
                return 10;
            }

            public String getValue(int index) {
                throw new UnsupportedOperationException();
            }

            public boolean hasNulls() {
                return false;
            }

            public BitmapFactory getBitmapFactory() {
                return new ConciseBitmapFactory();
            }

            public int getIndex(String value) {
                throw new UnsupportedOperationException();
            }

            public ImmutableBitmap getBitmap(int idx) {
                return (ImmutableBitmap)bitmapList.get(idx);
            }
        };
    }

    private static BitmapIndex makeNonOverlappedBitmapIndexes(int bitmapNum, List<ImmutableBitmap> bitmaps) {
        BitmapIndex bitmapIndex = FiltersTest.getBitmapIndex(bitmaps);
        BitmapFactory factory = bitmapIndex.getBitmapFactory();
        for (int i = 0; i < bitmapNum; ++i) {
            MutableBitmap mutableBitmap = factory.makeEmptyMutableBitmap();
            for (int j = 0; j < 10; ++j) {
                mutableBitmap.add(i * 10 + j);
            }
            bitmaps.add(factory.makeImmutableBitmap(mutableBitmap));
        }
        return bitmapIndex;
    }
}

