/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryEngine;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryEngine;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexStorageAdapterTest
extends InitializedNullHandlingTest {
    public final IncrementalIndexCreator indexCreator;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexStorageAdapterTest(String indexType) throws JsonProcessingException {
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).setMaxRowCount(1000).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.getAppendableIndexTypes();
    }

    @Test
    public void testSanity() throws Exception {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        try (CloseableStupidPool pool = new CloseableStupidPool("GroupByQueryEngine-bufferPool", () -> ByteBuffer.allocate(50000));){
            GroupByQueryEngine engine = new GroupByQueryEngine(Suppliers.ofInstance((Object)new GroupByQueryConfig(){

                public int getMaxIntermediateRows() {
                    return 5;
                }
            }), (NonBlockingPool)pool);
            Sequence rows = engine.process(GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index));
            List results = rows.toList();
            Assert.assertEquals((long)2L, (long)results.size());
            MapBasedRow row = (MapBasedRow)results.get(0);
            Assert.assertEquals((Object)ImmutableMap.of((Object)"sally", (Object)"bo", (Object)"cnt", (Object)1L), (Object)row.getEvent());
            row = (MapBasedRow)results.get(1);
            Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hi", (Object)"cnt", (Object)1L), (Object)row.getEvent());
        }
    }

    @Test
    public void testObjectColumnSelectorOnVaryingColumnSchema() throws Exception {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2014-09-01T00:00:00"), Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2014-09-01T01:00:00"), (List)Lists.newArrayList((Object[])new String[]{"billy", "sally"}), (Map)ImmutableMap.of((Object)"billy", (Object)"hip", (Object)"sally", (Object)"hop")));
        try (CloseableStupidPool pool = new CloseableStupidPool("GroupByQueryEngine-bufferPool", () -> ByteBuffer.allocate(50000));){
            GroupByQueryEngine engine = new GroupByQueryEngine(Suppliers.ofInstance((Object)new GroupByQueryConfig(){

                public int getMaxIntermediateRows() {
                    return 5;
                }
            }), (NonBlockingPool)pool);
            Sequence rows = engine.process(GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).addAggregator((AggregatorFactory)new JavaScriptAggregatorFactory("fieldLength", Arrays.asList("sally", "billy"), "function(current, s, b) { return current + (s == null ? 0 : s.length) + (b == null ? 0 : b.length); }", "function() { return 0; }", "function(a,b) { return a + b; }", JavaScriptConfig.getEnabledInstance())).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index));
            List results = rows.toList();
            Assert.assertEquals((long)2L, (long)results.size());
            MapBasedRow row = (MapBasedRow)results.get(0);
            Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hi", (Object)"cnt", (Object)1L, (Object)"fieldLength", (Object)2.0), (Object)row.getEvent());
            row = (MapBasedRow)results.get(1);
            Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hip", (Object)"sally", (Object)"hop", (Object)"cnt", (Object)1L, (Object)"fieldLength", (Object)6.0), (Object)row.getEvent());
        }
    }

    @Test
    public void testResetSanity() throws IOException {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        DateTime t = DateTimes.nowUtc();
        Interval interval = new Interval((ReadableInstant)t.minusMinutes(1), (ReadableInstant)t.plusMinutes(1));
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        IncrementalIndexStorageAdapter adapter = new IncrementalIndexStorageAdapter(index);
        for (boolean descending : Arrays.asList(false, true)) {
            Sequence cursorSequence = adapter.makeCursors((Filter)new SelectorFilter("sally", "bo"), interval, VirtualColumns.EMPTY, Granularities.NONE, descending, null);
            Cursor cursor = (Cursor)cursorSequence.limit(1L).toList().get(0);
            DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("sally", "sally"));
            Assert.assertEquals((Object)"bo", (Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
            index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"ah")));
            cursor.reset();
            dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("sally", "sally"));
            Assert.assertEquals((Object)"bo", (Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
        }
    }

    @Test
    public void testSingleValueTopN() throws IOException {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        DateTime t = DateTimes.nowUtc();
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        try (CloseableStupidPool pool = new CloseableStupidPool("TopNQueryEngine-bufferPool", () -> ByteBuffer.allocate(50000));){
            TopNQueryEngine engine = new TopNQueryEngine((NonBlockingPool)pool);
            List results = engine.query(new TopNQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals(Collections.singletonList(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc()))).dimension("sally").metric("cnt").threshold(10).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("cnt", "cnt")}).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index), null).toList();
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)results));
            Assert.assertEquals((long)1L, (long)((TopNResultValue)((Result)results.iterator().next()).getValue()).getValue().size());
        }
    }

    @Test
    public void testFilterByNull() throws Exception {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        try (CloseableStupidPool pool = new CloseableStupidPool("GroupByQueryEngine-bufferPool", () -> ByteBuffer.allocate(50000));){
            GroupByQueryEngine engine = new GroupByQueryEngine(Suppliers.ofInstance((Object)new GroupByQueryConfig(){

                public int getMaxIntermediateRows() {
                    return 5;
                }
            }), (NonBlockingPool)pool);
            Sequence rows = engine.process(GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).setDimFilter((DimFilter)DimFilters.dimEquals((String)"sally", (String)null)).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index));
            List results = rows.toList();
            Assert.assertEquals((long)1L, (long)results.size());
            MapBasedRow row = (MapBasedRow)results.get(0);
            Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hi", (Object)"cnt", (Object)1L), (Object)row.getEvent());
        }
    }

    @Test
    public void testCursoringAndIndexUpdationInterleaving() throws Exception {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        long timestamp = System.currentTimeMillis();
        for (int i = 0; i < 2; ++i) {
            index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)("v1" + i))));
        }
        IncrementalIndexStorageAdapter sa = new IncrementalIndexStorageAdapter(index);
        Sequence cursors = sa.makeCursors(null, Intervals.utc((long)(timestamp - 60000L), (long)(timestamp + 60000L)), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        AtomicInteger assertCursorsNotEmpty = new AtomicInteger(0);
        cursors.map(cursor -> {
            DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            int cardinality = dimSelector.getValueCardinality();
            try {
                for (int i2 = 0; i2 < 1; ++i2) {
                    index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)("v2" + i2))));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            int rowNumInCursor = 0;
            while (!cursor.isDone()) {
                IndexedInts row = dimSelector.getRow();
                row.forEach(i -> Assert.assertTrue((i < cardinality ? 1 : 0) != 0));
                cursor.advance();
                ++rowNumInCursor;
            }
            Assert.assertEquals((long)2L, (long)rowNumInCursor);
            assertCursorsNotEmpty.incrementAndGet();
            return null;
        }).toList();
        Assert.assertEquals((long)1L, (long)assertCursorsNotEmpty.get());
    }

    @Test
    public void testCursorDictionaryRaceConditionFix() throws Exception {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        long timestamp = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)("v1" + i))));
        }
        IncrementalIndexStorageAdapter sa = new IncrementalIndexStorageAdapter(index);
        Sequence cursors = sa.makeCursors((Filter)new DictionaryRaceTestFilter(index, timestamp), Intervals.utc((long)(timestamp - 60000L), (long)(timestamp + 60000L)), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        AtomicInteger assertCursorsNotEmpty = new AtomicInteger(0);
        cursors.map(cursor -> {
            DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            int cardinality = dimSelector.getValueCardinality();
            int rowNumInCursor = 0;
            while (!cursor.isDone()) {
                IndexedInts row = dimSelector.getRow();
                row.forEach(i -> Assert.assertTrue((i < cardinality ? 1 : 0) != 0));
                cursor.advance();
                ++rowNumInCursor;
            }
            Assert.assertEquals((long)5L, (long)rowNumInCursor);
            assertCursorsNotEmpty.incrementAndGet();
            return null;
        }).toList();
        Assert.assertEquals((long)1L, (long)assertCursorsNotEmpty.get());
    }

    @Test
    public void testCursoringAndSnapshot() throws Exception {
        IncrementalIndex<?> index = this.indexCreator.createIndex(new Object[0]);
        long timestamp = System.currentTimeMillis();
        for (int i = 0; i < 2; ++i) {
            index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)("v0" + i))));
        }
        IncrementalIndexStorageAdapter sa = new IncrementalIndexStorageAdapter(index);
        Sequence cursors = sa.makeCursors(null, Intervals.utc((long)(timestamp - 60000L), (long)(timestamp + 60000L)), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        AtomicInteger assertCursorsNotEmpty = new AtomicInteger(0);
        cursors.map(cursor -> {
            DimensionSelector dimSelector1A = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            int cardinalityA = dimSelector1A.getValueCardinality();
            try {
                index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v1")));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            DimensionSelector dimSelector1B = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            try {
                index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v2")));
                index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy2"), (Map)ImmutableMap.of((Object)"billy2", (Object)"v3")));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            DimensionSelector dimSelector1C = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            DimensionSelector dimSelector2D = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy2", "billy2"));
            try {
                index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v3")));
                index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy3"), (Map)ImmutableMap.of((Object)"billy3", (Object)"")));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            DimensionSelector dimSelector3E = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy3", "billy3"));
            int rowNumInCursor = 0;
            while (!cursor.isDone()) {
                IndexedInts rowA = dimSelector1A.getRow();
                rowA.forEach(i -> Assert.assertTrue((i < cardinalityA ? 1 : 0) != 0));
                IndexedInts rowB = dimSelector1B.getRow();
                rowB.forEach(i -> Assert.assertTrue((i < cardinalityA ? 1 : 0) != 0));
                IndexedInts rowC = dimSelector1C.getRow();
                rowC.forEach(i -> Assert.assertTrue((i < cardinalityA ? 1 : 0) != 0));
                IndexedInts rowD = dimSelector2D.getRow();
                Assert.assertEquals((long)0L, (long)rowD.size());
                IndexedInts rowE = dimSelector3E.getRow();
                if (NullHandling.replaceWithDefault()) {
                    Assert.assertEquals((long)1L, (long)rowE.size());
                    Assert.assertEquals((long)0L, (long)rowE.get(0));
                } else {
                    Assert.assertEquals((long)0L, (long)rowE.size());
                }
                cursor.advance();
                ++rowNumInCursor;
            }
            Assert.assertEquals((long)2L, (long)rowNumInCursor);
            assertCursorsNotEmpty.incrementAndGet();
            return null;
        }).toList();
        Assert.assertEquals((long)1L, (long)assertCursorsNotEmpty.get());
    }

    private static class DictionaryRaceTestFilter
    implements Filter {
        private final IncrementalIndex index;
        private final long timestamp;

        private DictionaryRaceTestFilter(IncrementalIndex index, long timestamp) {
            this.index = index;
            this.timestamp = timestamp;
        }

        public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
            return (T)bitmapResultFactory.wrapAllTrue(Filters.allTrue((BitmapIndexSelector)selector));
        }

        public double estimateSelectivity(BitmapIndexSelector indexSelector) {
            return 1.0;
        }

        public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
            return Filters.makeValueMatcher((ColumnSelectorFactory)factory, (String)"billy", (DruidPredicateFactory)new DictionaryRaceTestFilterDruidPredicateFactory());
        }

        public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
            return true;
        }

        public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
            return true;
        }

        public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
            return true;
        }

        public Set<String> getRequiredColumns() {
            return Collections.emptySet();
        }

        public int hashCode() {
            return super.hashCode();
        }

        private class DictionaryRaceTestFilterDruidPredicateFactory
        implements DruidPredicateFactory {
            private DictionaryRaceTestFilterDruidPredicateFactory() {
            }

            public Predicate<String> makeStringPredicate() {
                try {
                    DictionaryRaceTestFilter.this.index.add((InputRow)new MapBasedInputRow(DictionaryRaceTestFilter.this.timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v31234")));
                }
                catch (IndexSizeExceededException isee) {
                    throw new RuntimeException(isee);
                }
                return Predicates.alwaysTrue();
            }

            public DruidLongPredicate makeLongPredicate() {
                throw new UnsupportedOperationException();
            }

            public DruidFloatPredicate makeFloatPredicate() {
                throw new UnsupportedOperationException();
            }

            public DruidDoublePredicate makeDoublePredicate() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

