/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.segment.incremental.AppendableIndexBuilder;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.OffheapIncrementalIndex;
import org.apache.druid.utils.JvmUtils;

public class OffheapIncrementalIndexTestSpec
implements AppendableIndexSpec,
Supplier<ByteBuffer>,
Closeable {
    public static final String TYPE = "offheap";
    static final int DEFAULT_BUFFER_SIZE = 0x800000;
    static final int DEFAULT_CACHE_SIZE = 0x40000000;
    final int bufferSize;
    final int cacheSize;
    final CloseableStupidPool<ByteBuffer> bufferPool;

    @JsonCreator
    public OffheapIncrementalIndexTestSpec(@JsonProperty(value="bufferSize") @Nullable Integer bufferSize, @JsonProperty(value="cacheSize") @Nullable Integer cacheSize) {
        this.bufferSize = bufferSize != null && bufferSize > 0 ? bufferSize : 0x800000;
        this.cacheSize = cacheSize != null && cacheSize > this.bufferSize ? cacheSize : 0x40000000;
        this.bufferPool = new CloseableStupidPool("Off-heap incremental-index buffer pool", (Supplier)this, 0, this.cacheSize / this.bufferSize);
    }

    @JsonProperty
    public int getBufferSize() {
        return this.bufferSize;
    }

    @JsonProperty
    public int getCacheSize() {
        return this.cacheSize;
    }

    public AppendableIndexBuilder builder() {
        return new OffheapIncrementalIndex.Builder().setBufferPool(this.bufferPool);
    }

    public long getDefaultMaxBytesInMemory() {
        return JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes() / 2L;
    }

    public ByteBuffer get() {
        return ByteBuffer.allocateDirect(this.bufferSize);
    }

    @Override
    public void close() {
        this.bufferPool.close();
    }
}

