/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.junit.Assert;

public class JoinTestHelper {
    private static final Logger log = new Logger(JoinTestHelper.class);
    private static final String FACT_TIME_COLUMN = "time";
    private static final List<DimensionSchema> FACT_DIMENSIONS = ImmutableList.of((Object)new StringDimensionSchema("channel"), (Object)new StringDimensionSchema("regionIsoCode"), (Object)new LongDimensionSchema("countryNumber"), (Object)new StringDimensionSchema("countryIsoCode"), (Object)new StringDimensionSchema("user"), (Object)new StringDimensionSchema("isRobot"), (Object)new StringDimensionSchema("isAnonymous"), (Object)new StringDimensionSchema("namespace"), (Object)new StringDimensionSchema("page"), (Object)new LongDimensionSchema("delta"));
    private static final RowSignature COUNTRIES_SIGNATURE = RowSignature.builder().add("countryNumber", ValueType.LONG).add("countryIsoCode", ValueType.STRING).add("countryName", ValueType.STRING).build();
    private static final RowSignature REGIONS_SIGNATURE = RowSignature.builder().add("regionIsoCode", ValueType.STRING).add("countryIsoCode", ValueType.STRING).add("regionName", ValueType.STRING).add("extraField", ValueType.STRING).build();
    private static final ColumnProcessorFactory<Supplier<Object>> SIMPLE_READER = new ColumnProcessorFactory<Supplier<Object>>(){

        public ValueType defaultType() {
            return ValueType.STRING;
        }

        public Supplier<Object> makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            return () -> ((DimensionSelector)selector).defaultGetObject();
        }

        public Supplier<Object> makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            return () -> NullHandling.sqlCompatible() && selector.isNull() ? null : Float.valueOf(selector.getFloat());
        }

        public Supplier<Object> makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            return () -> NullHandling.sqlCompatible() && selector.isNull() ? null : Double.valueOf(selector.getDouble());
        }

        public Supplier<Object> makeLongProcessor(BaseLongColumnValueSelector selector) {
            return () -> NullHandling.sqlCompatible() && selector.isNull() ? null : Long.valueOf(selector.getLong());
        }

        public Supplier<Object> makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return () -> selector.getObject();
        }
    };
    public static final String INDEXED_TABLE_VERSION = DateTimes.nowUtc().toString();
    public static final byte[] INDEXED_TABLE_CACHE_KEY = new byte[]{1, 2, 3};

    private static RowAdapter<Map<String, Object>> createMapRowAdapter(final RowSignature signature) {
        return new RowAdapter<Map<String, Object>>(){

            public ToLongFunction<Map<String, Object>> timestampFunction() {
                return row -> 0L;
            }

            public Function<Map<String, Object>, Object> columnFunction(String columnName) {
                ValueType columnType = signature.getColumnType(columnName).orElse(null);
                if (columnType == null) {
                    return row -> row.get(columnName);
                }
                return row -> DimensionHandlerUtils.convertObjectToType(row.get(columnName), (ValueType)columnType, (boolean)false);
            }
        };
    }

    public static IndexBuilder createFactIndexBuilder(File tmpDir) throws IOException {
        return JoinTestHelper.createFactIndexBuilder(TestHelper.NO_CACHE_COLUMN_CONFIG, tmpDir, -1);
    }

    public static IndexBuilder createFactIndexBuilder(ColumnConfig columnConfig, File tmpDir, int numRows) throws IOException {
        return JoinTestHelper.withRowsFromResource("/wikipedia/data.json", rows -> IndexBuilder.create(columnConfig).tmpDir(tmpDir).schema(new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(FACT_DIMENSIONS)).withMetrics(new AggregatorFactory[]{new HyperUniquesAggregatorFactory("channel_uniques", "channel")}).withQueryGranularity(Granularities.NONE).withRollup(false).withMinTimestamp(DateTimes.of((String)"2015-09-12").getMillis()).build()).rows(() -> IntStream.rangeClosed(0, numRows < 0 ? 0 : numRows / rows.size() + 1).boxed().flatMap(i -> rows.stream().map(row -> new MapBasedInputRow(DateTimes.of((String)((String)row.get(FACT_TIME_COLUMN))), FACT_DIMENSIONS.stream().map(DimensionSchema::getName).collect(Collectors.toList()), row))).limit(numRows < 0 ? Long.MAX_VALUE : (long)numRows).iterator()));
    }

    public static MapLookupExtractor createCountryIsoCodeToNameLookup() throws IOException {
        return JoinTestHelper.withRowsFromResource("/wikipedia/countries.json", rows -> {
            LinkedHashMap<String, String> lookupMap = new LinkedHashMap<String, String>();
            for (Map row : rows) {
                lookupMap.put((String)row.get("countryIsoCode"), (String)row.get("countryName"));
            }
            return new MapLookupExtractor(lookupMap, false);
        });
    }

    public static MapLookupExtractor createCountryNumberToNameLookup() throws IOException {
        return JoinTestHelper.withRowsFromResource("/wikipedia/countries.json", rows -> new MapLookupExtractor(rows.stream().collect(Collectors.toMap(row -> row.get("countryNumber").toString(), row -> (String)row.get("countryName"))), false));
    }

    public static RowBasedIndexedTable<Map<String, Object>> createCountriesIndexedTable() throws IOException {
        return JoinTestHelper.withRowsFromResource("/wikipedia/countries.json", rows -> new RowBasedIndexedTable(rows, JoinTestHelper.createMapRowAdapter(COUNTRIES_SIGNATURE), COUNTRIES_SIGNATURE, (Set)ImmutableSet.of((Object)"countryNumber", (Object)"countryIsoCode"), INDEXED_TABLE_VERSION));
    }

    public static RowBasedIndexedTable<Map<String, Object>> createCountriesIndexedTableWithCacheKey() throws IOException {
        return JoinTestHelper.withRowsFromResource("/wikipedia/countries.json", rows -> new RowBasedIndexedTable(rows, JoinTestHelper.createMapRowAdapter(COUNTRIES_SIGNATURE), COUNTRIES_SIGNATURE, (Set)ImmutableSet.of((Object)"countryNumber", (Object)"countryIsoCode"), INDEXED_TABLE_VERSION, INDEXED_TABLE_CACHE_KEY));
    }

    public static RowBasedIndexedTable<Map<String, Object>> createRegionsIndexedTable() throws IOException {
        return JoinTestHelper.withRowsFromResource("/wikipedia/regions.json", rows -> new RowBasedIndexedTable(rows, JoinTestHelper.createMapRowAdapter(REGIONS_SIGNATURE), REGIONS_SIGNATURE, (Set)ImmutableSet.of((Object)"regionIsoCode", (Object)"countryIsoCode"), INDEXED_TABLE_VERSION));
    }

    public static List<Object[]> readCursors(Sequence<Cursor> cursors, List<String> columns) {
        return cursors.flatMap(cursor -> {
            List readers = columns.stream().map(column -> (Supplier)ColumnProcessors.makeProcessor((String)column, SIMPLE_READER, (ColumnSelectorFactory)cursor.getColumnSelectorFactory())).collect(Collectors.toList());
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (!cursor.isDone()) {
                Object[] row = new Object[columns.size()];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = ((Supplier)readers.get(i)).get();
                }
                rows.add(row);
                cursor.advance();
            }
            return Sequences.simple(rows);
        }).toList();
    }

    public static void verifyCursors(Sequence<Cursor> cursors, List<String> columns, List<Object[]> expectedRows) {
        int i;
        List<Object[]> rows = JoinTestHelper.readCursors(cursors, columns);
        for (i = 0; i < rows.size(); ++i) {
            try {
                log.info("Row #%-2d: %s", new Object[]{i, TestHelper.JSON_MAPPER.writeValueAsString((Object)rows.get(i))});
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertEquals((String)"number of rows", (long)expectedRows.size(), (long)rows.size());
        for (i = 0; i < rows.size(); ++i) {
            Assert.assertArrayEquals((String)("row #" + i), (Object[])expectedRows.get(i), (Object[])rows.get(i));
        }
    }

    /*
     * Exception decompiling
     */
    private static <T> T withRowsFromResource(String resource, Function<List<Map<String, Object>>, T> f) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

