/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.join.table.SortedIntIntersectionIterator;
import org.junit.Assert;
import org.junit.Test;

public class SortedIntIntersectionIteratorTest {
    @Test
    public void test_iterator_allPossibleSingleListsWithCardinalityUpToThree() {
        for (int i = 0; i < 8; ++i) {
            IntList ints = SortedIntIntersectionIteratorTest.intsFromBits(i);
            Assert.assertEquals((String)ints.toString(), (Object)ints, (Object)SortedIntIntersectionIteratorTest.intersection(ints));
        }
    }

    @Test
    public void test_iterator_allPossibleSetsOfTwoListsWithCardinalityUpToSix() {
        for (int i = 0; i < 4096; ++i) {
            int bits1 = i & 0x3F;
            int bits2 = i >> 6 & 0x3F;
            IntList ints1 = SortedIntIntersectionIteratorTest.intsFromBits(bits1);
            IntList ints2 = SortedIntIntersectionIteratorTest.intsFromBits(bits2);
            Assert.assertEquals((String)StringUtils.format((String)"ints1 = %s; ints2 = %s", (Object[])new Object[]{ints1, ints2}), (Object)SortedIntIntersectionIteratorTest.intsFromBits(bits1 & bits2), (Object)SortedIntIntersectionIteratorTest.intersection(ints1, ints2));
        }
    }

    @Test
    public void test_iterator_allPossibleSetsOfThreeListsWithCardinalityUpToFour() {
        for (int i = 0; i < 4096; ++i) {
            int bits1 = i & 0xF;
            int bits2 = i >> 4 & 0xF;
            int bits3 = i >> 8 & 0xF;
            IntList ints1 = SortedIntIntersectionIteratorTest.intsFromBits(bits1);
            IntList ints2 = SortedIntIntersectionIteratorTest.intsFromBits(bits2);
            IntList ints3 = SortedIntIntersectionIteratorTest.intsFromBits(bits3);
            Assert.assertEquals((String)StringUtils.format((String)"ints1 = %s; ints2 = %s; ints3 = %s", (Object[])new Object[]{ints1, ints2, ints3}), (Object)SortedIntIntersectionIteratorTest.intsFromBits(bits1 & bits2 & bits3), (Object)SortedIntIntersectionIteratorTest.intersection(ints1, ints2, ints3));
        }
    }

    private static IntList intersection(IntList ... lists) {
        SortedIntIntersectionIterator comboIterator = new SortedIntIntersectionIterator((IntIterator[])Arrays.stream(lists).map(IntList::iterator).toArray(IntIterator[]::new));
        return new IntArrayList((IntIterator)comboIterator);
    }

    private static IntList intsFromBits(int bits) {
        IntArrayList retVal = new IntArrayList(4);
        for (int i = 0; i < 32; ++i) {
            if ((bits >> i & 1) != 1) continue;
            retVal.add(i);
        }
        return retVal;
    }
}

