/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.selector;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.joda.time.DateTime;

public class TestColumnValueSelector<T>
implements ColumnValueSelector<Object>,
Cursor {
    private final Class<T> clazz;
    private final Supplier<Iterator<Object>> iteratorSupplier;
    private final DateTime time;
    private Iterator<Object> iterator;
    private Object value;

    public static <T> TestColumnValueSelector<T> of(Class<T> clazz, Collection<Object> collection, DateTime time) {
        return new TestColumnValueSelector<T>(clazz, collection::iterator, time);
    }

    public static <T> TestColumnValueSelector<T> of(Class<T> clazz, Stream<Object> stream, DateTime time) {
        return new TestColumnValueSelector<T>(clazz, stream::iterator, time);
    }

    protected TestColumnValueSelector(Class<T> clazz, Supplier<Iterator<Object>> iteratorSupplier, DateTime time) {
        this.clazz = clazz;
        this.iteratorSupplier = iteratorSupplier;
        this.time = time;
        this.iterator = iteratorSupplier.get();
    }

    public ColumnSelectorFactory getColumnSelectorFactory() {
        return new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                throw new UnsupportedOperationException("Not implemented");
            }

            public ColumnValueSelector makeColumnValueSelector(String columnName) {
                return TestColumnValueSelector.this;
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return null;
            }
        };
    }

    public DateTime getTime() {
        return this.time;
    }

    public void advance() {
        this.value = this.iterator.next();
    }

    public void advanceUninterruptibly() {
        this.advance();
    }

    public boolean isDone() {
        return !this.iterator.hasNext();
    }

    public boolean isDoneOrInterrupted() {
        return this.isDone();
    }

    public void reset() {
        this.iterator = this.iteratorSupplier.get();
    }

    public double getDouble() {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return Double.parseDouble(this.value.toString());
    }

    public float getFloat() {
        if (this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return Float.parseFloat(this.value.toString());
    }

    public long getLong() {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return Long.parseLong(this.value.toString());
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Nullable
    public Object getObject() {
        return this.value;
    }

    public Class<? extends T> classOfObject() {
        return this.clazz;
    }
}

