/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.CountVectorAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.junit.Assert;

public class AlwaysTwoCounterAggregatorFactory
extends CountAggregatorFactory {
    private final String fieldName;

    public AlwaysTwoCounterAggregatorFactory(String name, String field) {
        super(name);
        this.fieldName = field;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        throw new IllegalStateException("don't call this");
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        throw new IllegalStateException("don't call this");
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(this.fieldName);
        switch (capabilities.getType()) {
            case LONG: 
            case DOUBLE: 
            case FLOAT: {
                return new AlwaysTwoCounterVectorAggregator(selectorFactory.makeValueSelector(this.fieldName));
            }
            case STRING: {
                if (capabilities.isDictionaryEncoded().isTrue()) {
                    if (capabilities.hasMultipleValues().isTrue()) {
                        return new AlwaysTwoCounterVectorAggregator(selectorFactory.makeMultiValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.fieldName)));
                    }
                    return new AlwaysTwoCounterVectorAggregator(selectorFactory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.fieldName)));
                }
                return new AlwaysTwoCounterVectorAggregator(selectorFactory.makeObjectSelector(this.fieldName));
            }
        }
        throw new IllegalStateException("how did this happen");
    }

    public static class AlwaysTwoCounterVectorAggregator
    extends CountVectorAggregator {
        @Nullable
        private final VectorValueSelector valueSelector;
        @Nullable
        private final VectorObjectSelector objectSelector;
        @Nullable
        private final SingleValueDimensionVectorSelector singleValueDimensionSelector;
        @Nullable
        private final MultiValueDimensionVectorSelector multiValueDimensionSelector;

        AlwaysTwoCounterVectorAggregator(VectorValueSelector valueSelector) {
            this(valueSelector, null, null, null);
        }

        AlwaysTwoCounterVectorAggregator(VectorObjectSelector objectSelector) {
            this(null, objectSelector, null, null);
        }

        AlwaysTwoCounterVectorAggregator(SingleValueDimensionVectorSelector dimSelector) {
            this(null, null, dimSelector, null);
        }

        AlwaysTwoCounterVectorAggregator(MultiValueDimensionVectorSelector dimSelector) {
            this(null, null, null, dimSelector);
        }

        AlwaysTwoCounterVectorAggregator(@Nullable VectorValueSelector valueSelector, @Nullable VectorObjectSelector objectSelector, @Nullable SingleValueDimensionVectorSelector singleValueDimensionSelector, @Nullable MultiValueDimensionVectorSelector multiValueDimensionSelector) {
            this.valueSelector = valueSelector;
            this.objectSelector = objectSelector;
            this.singleValueDimensionSelector = singleValueDimensionSelector;
            this.multiValueDimensionSelector = multiValueDimensionSelector;
        }

        public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
            if (this.valueSelector != null) {
                long[] vector = this.valueSelector.getLongVector();
                long count = 0L;
                for (int i = startRow; i < endRow; ++i) {
                    Assert.assertEquals((long)2L, (long)vector[i]);
                    ++count;
                }
                buf.putLong(position, buf.getLong(position) + count);
                return;
            }
            if (this.objectSelector != null) {
                Object[] vector = this.objectSelector.getObjectVector();
                long count = 0L;
                for (int i = startRow; i < endRow; ++i) {
                    if (vector[i] instanceof List) {
                        Assert.assertEquals((Object)ImmutableList.of((Object)"2", (Object)"2"), (Object)vector[i]);
                        count += 2L;
                        continue;
                    }
                    Assert.assertEquals((Object)"2", (Object)vector[i]);
                    ++count;
                }
                buf.putLong(position, buf.getLong(position) + count);
                return;
            }
            if (this.singleValueDimensionSelector != null) {
                int[] rowVector = this.singleValueDimensionSelector.getRowVector();
                long count = 0L;
                for (int i = startRow; i < endRow; ++i) {
                    Assert.assertEquals((Object)"2", (Object)this.singleValueDimensionSelector.lookupName(rowVector[i]));
                    ++count;
                }
                buf.putLong(position, buf.getLong(position) + count);
                return;
            }
            if (this.multiValueDimensionSelector != null) {
                IndexedInts[] rowVector = this.multiValueDimensionSelector.getRowVector();
                long count = 0L;
                for (int i = startRow; i < endRow; ++i) {
                    for (int j = 0; j < rowVector[i].size(); ++j) {
                        Assert.assertEquals((Object)"2", (Object)this.multiValueDimensionSelector.lookupName(rowVector[i].get(j)));
                        ++count;
                    }
                }
                buf.putLong(position, buf.getLong(position) + count);
                return;
            }
            throw new IllegalStateException("how did this happen");
        }

        public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
            if (this.valueSelector != null) {
                long[] vector = this.valueSelector.getLongVector();
                for (int i = 0; i < numRows; ++i) {
                    int position = positions[i] + positionOffset;
                    Assert.assertEquals((long)2L, (long)vector[i]);
                    buf.putLong(position, buf.getLong(position) + 1L);
                }
                return;
            }
            if (this.objectSelector != null) {
                Object[] vector = this.objectSelector.getObjectVector();
                for (int i = 0; i < numRows; ++i) {
                    int position = positions[i] + positionOffset;
                    if (vector[i] instanceof List) {
                        Assert.assertEquals((Object)ImmutableList.of((Object)"2", (Object)"2"), (Object)vector[i]);
                        buf.putLong(position, buf.getLong(position) + 2L);
                        continue;
                    }
                    Assert.assertEquals((Object)"2", (Object)vector[i]);
                    buf.putLong(position, buf.getLong(position) + 1L);
                }
                return;
            }
            if (this.singleValueDimensionSelector != null) {
                int[] rowVector = this.singleValueDimensionSelector.getRowVector();
                for (int i = 0; i < numRows; ++i) {
                    int position = positions[i] + positionOffset;
                    Assert.assertEquals((Object)"2", (Object)this.singleValueDimensionSelector.lookupName(rowVector[i]));
                    buf.putLong(position, buf.getLong(position) + 1L);
                }
                return;
            }
            if (this.multiValueDimensionSelector != null) {
                IndexedInts[] rowVector = this.multiValueDimensionSelector.getRowVector();
                for (int i = 0; i < numRows; ++i) {
                    int position = positions[i] + positionOffset;
                    for (int j = 0; j < rowVector[i].size(); ++j) {
                        Assert.assertEquals((Object)"2", (Object)this.multiValueDimensionSelector.lookupName(rowVector[i].get(j)));
                        buf.putLong(position, buf.getLong(position) + 1L);
                    }
                }
                return;
            }
            throw new IllegalStateException("how did this happen");
        }
    }
}

