/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.TestObjectColumnSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionSelectorsTest
extends InitializedNullHandlingTest {
    @Test
    public void test_canMapOverDictionary_oneSingleValueInput() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.FALSE));
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInputSpecifiedTwice() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"concat(dim1, dim1) == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.FALSE));
    }

    @Test
    public void test_canMapOverDictionary_oneMultiValueInput() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.TRUE));
    }

    @Test
    public void test_canMapOverDictionary_oneUnknownInput() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.UNKNOWN));
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.FALSE));
    }

    @Test
    public void test_canMapOverDictionary_oneMultiValueInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.TRUE));
    }

    @Test
    public void test_canMapOverDictionary_oneUnknownInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.UNKNOWN));
    }

    @Test
    public void test_canMapOverDictionary() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities.Capable)ColumnCapabilities.Capable.FALSE));
    }

    @Test
    public void test_supplierFromDimensionSelector() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromDimensionSelector((DimensionSelector)ExpressionSelectorsTest.dimensionSelectorFromSupplier((Supplier<String>)settableSupplier), (boolean)false);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set(null);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onObject() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, Object.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
        settableSupplier.set((Object)"1.234");
        Assert.assertEquals((Object)"1.234", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onNumber() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, Number.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onString() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, String.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1.1");
        Assert.assertEquals((Object)"1.1", (Object)supplier.get());
        settableSupplier.set((Object)"1");
        Assert.assertEquals((Object)"1", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onList() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, List.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((Object[])supplier.get()));
    }

    @Test
    public void test_coerceEvalToSelectorObject() {
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofLongArray((Long[])new Long[]{1L, 2L, 3L})));
        Assert.assertEquals((Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofDoubleArray((Double[])new Double[]{1.0, 2.0, 3.0})));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofStringArray((String[])new String[]{"a", "b", "c"})));
        ArrayList<String> withNulls = new ArrayList<String>();
        withNulls.add("a");
        withNulls.add(null);
        withNulls.add("c");
        Assert.assertEquals(withNulls, (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofStringArray((String[])new String[]{"a", null, "c"})));
    }

    @Test
    public void test_incrementalIndexStringSelector() throws IndexSizeExceededException {
        IncrementalIndexSchema schema = new IncrementalIndexSchema(0L, new TimestampSpec("time", "millis", DateTimes.nowUtc()), Granularities.NONE, VirtualColumns.EMPTY, DimensionsSpec.EMPTY, new AggregatorFactory[]{new CountAggregatorFactory("count")}, true);
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(schema).build();
        index.add((InputRow)new MapBasedInputRow(DateTimes.nowUtc().getMillis(), (List)ImmutableList.of((Object)"x"), (Map)ImmutableMap.of((Object)"x", (Object)"foo")));
        index.add((InputRow)new MapBasedInputRow(DateTimes.nowUtc().plusMillis(1000).getMillis(), (List)ImmutableList.of((Object)"y"), (Map)ImmutableMap.of((Object)"y", (Object)"foo")));
        IncrementalIndexStorageAdapter adapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursors = adapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
        int rowsProcessed = (Integer)cursors.map(cursor -> {
            DimensionSelector xExprSelector = ExpressionSelectors.makeDimensionSelector((ColumnSelectorFactory)cursor.getColumnSelectorFactory(), (Expr)Parser.parse((String)"concat(x, 'foo')", (ExprMacroTable)ExprMacroTable.nil()), null);
            DimensionSelector yExprSelector = ExpressionSelectors.makeDimensionSelector((ColumnSelectorFactory)cursor.getColumnSelectorFactory(), (Expr)Parser.parse((String)"concat(y, 'foo')", (ExprMacroTable)ExprMacroTable.nil()), null);
            int rowCount = 0;
            while (!cursor.isDone()) {
                List<String> expectedNull;
                Object x = xExprSelector.getObject();
                Object y = yExprSelector.getObject();
                List<String> expectedFoo = Collections.singletonList("foofoo");
                List<String> list = expectedNull = NullHandling.replaceWithDefault() ? Collections.singletonList("foo") : Collections.singletonList(null);
                if (rowCount == 0) {
                    Assert.assertEquals(expectedFoo, (Object)x);
                    Assert.assertEquals(expectedNull, (Object)y);
                } else {
                    Assert.assertEquals(expectedNull, (Object)x);
                    Assert.assertEquals(expectedFoo, (Object)y);
                }
                ++rowCount;
                cursor.advance();
            }
            return rowCount;
        }).accumulate((Object)0, (in, acc) -> in + acc);
        Assert.assertEquals((long)2L, (long)rowsProcessed);
    }

    private static DimensionSelector dimensionSelectorFromSupplier(final Supplier<String> supplier) {
        return new BaseSingleValueDimensionSelector(){

            protected String getValue() {
                return (String)supplier.get();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("supplier", (Object)supplier);
            }
        };
    }

    private static <T> ColumnValueSelector<T> objectSelectorFromSupplier(final Supplier<T> supplier, final Class<T> clazz) {
        return new TestObjectColumnSelector<T>(){

            public Class<T> classOfObject() {
                return clazz;
            }

            public T getObject() {
                return supplier.get();
            }
        };
    }
}

