/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.AlwaysTwoCounterAggregatorFactory;
import org.apache.druid.segment.virtual.AlwaysTwoVectorizedVirtualColumn;
import org.apache.druid.timeline.SegmentId;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class VectorizedVirtualColumnTest {
    private static final String ALWAYS_TWO = "two";
    private static final String COUNT = "count";
    private static final Map<String, Object> CONTEXT_USE_DEFAULTS = ImmutableMap.of();
    private static final Map<String, Object> CONTEXT_VECTORIZE_FORCE = ImmutableMap.of((Object)"vectorize", (Object)"force", (Object)"vectorizeVirtualColumns", (Object)"force");
    private static final Map<String, Object> CONTEXT_VECTORIZE_TRUE_VIRTUAL_FORCE = ImmutableMap.of((Object)"vectorize", (Object)"true", (Object)"vectorizeVirtualColumns", (Object)"force");
    private static final Map<String, Object> CONTEXT_CONTRADICTION_VECTORIZE_FALSE_VIRTUAL_FORCE = ImmutableMap.of((Object)"vectorize", (Object)"false", (Object)"vectorizeVirtualColumns", (Object)"force");
    private static final Map<String, Object> CONTEXT_CONTRADICTION_VECTORIZE_FORCE_VIRTUAL_FALSE = ImmutableMap.of((Object)"vectorize", (Object)"force", (Object)"vectorizeVirtualColumns", (Object)"false");
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private AggregationTestHelper groupByTestHelper;
    private AggregationTestHelper timeseriesTestHelper;
    private List<Segment> segments = null;

    @Before
    public void setup() {
        this.groupByTestHelper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.emptyList(), new GroupByQueryConfig(), this.tmpFolder);
        this.timeseriesTestHelper = AggregationTestHelper.createTimeseriesQueryAggregationTestHelper(Collections.emptyList(), this.tmpFolder);
        QueryableIndexSegment queryableIndexSegment = new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"testing"));
        this.segments = Lists.newArrayList((Object[])new Segment[]{queryableIndexSegment, queryableIndexSegment});
    }

    @Test
    public void testGroupBySingleValueString() {
        this.testGroupBy((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(false));
    }

    @Test
    public void testGroupByMultiValueString() {
        this.cannotVectorize();
        this.testGroupBy((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(true));
    }

    @Test
    public void testGroupByMultiValueStringUnknown() {
        this.cannotVectorize();
        this.testGroupBy((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true));
    }

    @Test
    public void testGroupBySingleValueStringNotDictionaryEncoded() {
        this.testGroupBy((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(false).setDictionaryValuesUnique(false).setHasMultipleValues(false));
    }

    @Test
    public void testGroupByMultiValueStringNotDictionaryEncoded() {
        this.cannotVectorize();
        this.testGroupBy((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(false).setDictionaryValuesUnique(false).setHasMultipleValues(true));
    }

    @Test
    public void testGroupByLong() {
        this.testGroupBy((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.LONG));
    }

    @Test
    public void testGroupByDouble() {
        this.testGroupBy((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.DOUBLE));
    }

    @Test
    public void testGroupByFloat() {
        this.testGroupBy((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT));
    }

    @Test
    public void testTimeseriesSingleValueString() {
        this.testTimeseries((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(false));
    }

    @Test
    public void testTimeseriesMultiValueString() {
        this.testTimeseries((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(true));
    }

    @Test
    public void testTimeseriesMultiValueStringUnknown() {
        this.testTimeseries((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true));
    }

    @Test
    public void testTimeseriesSingleValueStringNotDictionaryEncoded() {
        this.testTimeseries((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(false).setDictionaryValuesUnique(false).setHasMultipleValues(false));
    }

    @Test
    public void testTimeseriesMultiValueStringNotDictionaryEncoded() {
        this.testTimeseries((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(false).setDictionaryValuesUnique(false).setHasMultipleValues(true));
    }

    @Test
    public void testTimeseriesLong() {
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.LONG));
    }

    @Test
    public void testTimeseriesDouble() {
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.DOUBLE));
    }

    @Test
    public void testTimeseriesFloat() {
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT));
    }

    @Test
    public void testTimeseriesForceContextCannotVectorize() {
        this.cannotVectorize();
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_VECTORIZE_FORCE, false);
    }

    @Test
    public void testTimeseriesForceVirtualContextCannotVectorize() {
        this.cannotVectorize();
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_VECTORIZE_TRUE_VIRTUAL_FORCE, false);
    }

    @Test
    public void testTimeseriesTrueVirtualContextCannotVectorize() {
        this.expectNonvectorized();
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_USE_DEFAULTS, true);
    }

    @Test
    public void testTimeseriesContradictionVectorizeFalseVirtualForce() {
        this.expectNonvectorized();
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_CONTRADICTION_VECTORIZE_FALSE_VIRTUAL_FORCE, true);
    }

    @Test
    public void testTimeseriesContradictionVectorizeForceVirtualFalse() {
        this.cannotVectorize();
        this.testTimeseries((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_CONTRADICTION_VECTORIZE_FORCE_VIRTUAL_FALSE, true);
    }

    @Test
    public void testTimeseriesContradictionVectorizeFalseVirtualForceNoVirtualColumns() {
        this.testTimeseriesNoVirtual((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_CONTRADICTION_VECTORIZE_FALSE_VIRTUAL_FORCE);
    }

    @Test
    public void testTimeseriesContradictionVectorizeForceVirtualFalseNoVirtual() {
        this.testTimeseriesNoVirtual((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_CONTRADICTION_VECTORIZE_FORCE_VIRTUAL_FALSE);
    }

    @Test
    public void testTimeseriesForceDoestAffectWhenNoVirtualColumns() {
        this.testTimeseriesNoVirtual((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_VECTORIZE_TRUE_VIRTUAL_FORCE);
    }

    @Test
    public void testGroupByForceContextCannotVectorize() {
        this.cannotVectorize();
        this.testGroupBy((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_VECTORIZE_FORCE, false);
    }

    @Test
    public void testGroupByForceVirtualContextCannotVectorize() {
        this.cannotVectorize();
        this.testGroupBy((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(false), CONTEXT_VECTORIZE_TRUE_VIRTUAL_FORCE, false);
    }

    @Test
    public void testGroupByTrueVirtualContextCannotVectorize() {
        this.expectNonvectorized();
        this.testGroupBy((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_USE_DEFAULTS, false);
    }

    @Test
    public void testGroupByContradictionVectorizeFalseVirtualForce() {
        this.expectNonvectorized();
        this.testGroupBy((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_CONTRADICTION_VECTORIZE_FALSE_VIRTUAL_FORCE, true);
    }

    @Test
    public void testGroupByContradictionVectorizeForceVirtualFalse() {
        this.cannotVectorize();
        this.testGroupBy((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((ValueType)ValueType.FLOAT), CONTEXT_CONTRADICTION_VECTORIZE_FORCE_VIRTUAL_FALSE, true);
    }

    @Test
    public void testGroupByContradictionVectorizeFalseVirtualForceNoVirtual() {
        this.testGroupByNoVirtual((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(false), CONTEXT_CONTRADICTION_VECTORIZE_FALSE_VIRTUAL_FORCE);
    }

    @Test
    public void testGroupByContradictionVectorizeForceVirtualFalseNoVirtual() {
        this.testGroupByNoVirtual((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(false), CONTEXT_CONTRADICTION_VECTORIZE_FORCE_VIRTUAL_FALSE);
    }

    @Test
    public void testGroupByForceDoestAffectWhenNoVirtualColumns() {
        this.testGroupByNoVirtual((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setHasMultipleValues(false), CONTEXT_VECTORIZE_TRUE_VIRTUAL_FORCE);
    }

    private void testTimeseries(ColumnCapabilities capabilities) {
        this.testTimeseries(capabilities, CONTEXT_VECTORIZE_FORCE, true);
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().intervals("2000/2030").dataSource("testing").granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new AlwaysTwoVectorizedVirtualColumn(ALWAYS_TWO, capabilities)}).aggregators(new AggregatorFactory[]{new AlwaysTwoCounterAggregatorFactory(COUNT, ALWAYS_TWO)}).context(CONTEXT_VECTORIZE_FORCE).build();
        Sequence seq = this.timeseriesTestHelper.runQueryOnSegmentsObjs(this.segments, query);
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)COUNT, (Object)this.getCount(capabilities)))));
        TestHelper.assertExpectedObjects(expectedResults, seq.toList(), "failed");
    }

    private void testTimeseries(ColumnCapabilities capabilities, Map<String, Object> context, boolean canVectorize) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().intervals("2000/2030").dataSource("testing").granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new AlwaysTwoVectorizedVirtualColumn(ALWAYS_TWO, capabilities, canVectorize)}).aggregators(new AggregatorFactory[]{new AlwaysTwoCounterAggregatorFactory(COUNT, ALWAYS_TWO)}).context(context).build();
        Sequence seq = this.timeseriesTestHelper.runQueryOnSegmentsObjs(this.segments, query);
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)COUNT, (Object)this.getCount(capabilities)))));
        TestHelper.assertExpectedObjects(expectedResults, seq.toList(), "failed");
    }

    private void testTimeseriesNoVirtual(ColumnCapabilities capabilities, Map<String, Object> context) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().intervals("2000/2030").dataSource("testing").granularity(Granularities.ALL).virtualColumns(new VirtualColumn[0]).aggregators(new AggregatorFactory[]{new CountAggregatorFactory(COUNT)}).context(context).build();
        Sequence seq = this.timeseriesTestHelper.runQueryOnSegmentsObjs(this.segments, query);
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)COUNT, (Object)2418L))));
        TestHelper.assertExpectedObjects(expectedResults, seq.toList(), "failed");
    }

    private void testGroupBy(ColumnCapabilities capabilities) {
        this.testGroupBy(capabilities, CONTEXT_VECTORIZE_FORCE, true);
    }

    private void testGroupBy(ColumnCapabilities capabilities, Map<String, Object> context, boolean canVectorize) {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new AlwaysTwoVectorizedVirtualColumn(ALWAYS_TWO, capabilities, canVectorize)}).addDimension((DimensionSpec)new DefaultDimensionSpec(ALWAYS_TWO, ALWAYS_TWO, capabilities.getType())).setAggregatorSpecs(new AggregatorFactory[]{new AlwaysTwoCounterAggregatorFactory(COUNT, ALWAYS_TWO)}).setInterval("2000/2030").setContext(context).addOrderByColumn(ALWAYS_TWO).build();
        List rows = this.groupByTestHelper.runQueryOnSegmentsObjs(this.segments, query).toList();
        List<ResultRow> expectedRows = Collections.singletonList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, this.getCount(capabilities), ALWAYS_TWO, this.getTwo(capabilities)));
        TestHelper.assertExpectedObjects(expectedRows, rows, "failed");
    }

    private void testGroupByNoVirtual(ColumnCapabilities capabilities, Map<String, Object> context) {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[0]).addDimension((DimensionSpec)new DefaultDimensionSpec("placement", "placement", capabilities.getType())).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory(COUNT)}).setInterval("2000/2030").setContext(context).build();
        List rows = this.groupByTestHelper.runQueryOnSegmentsObjs(this.segments, query).toList();
        List<ResultRow> expectedRows = Collections.singletonList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, 2418L, "placement", "preferred"));
        TestHelper.assertExpectedObjects(expectedRows, rows, "failed");
    }

    private long getCount(ColumnCapabilities capabilities) {
        long modifier = 1L;
        if (capabilities.hasMultipleValues().isTrue()) {
            modifier = 2L;
        }
        return 2418L * modifier;
    }

    private Object getTwo(ColumnCapabilities capabilities) {
        switch (capabilities.getType()) {
            case LONG: {
                return 2L;
            }
            case DOUBLE: {
                return 2.0;
            }
            case FLOAT: {
                return Float.valueOf(2.0f);
            }
        }
        if (capabilities.hasMultipleValues().isTrue()) {
            return ImmutableList.of((Object)"2", (Object)"2");
        }
        return "2";
    }

    private void expectNonvectorized() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("don't call this");
    }

    private void cannotVectorize() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Cannot vectorize!");
    }
}

