/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.druid.segment.writeout.FileWriteOutBytes;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileWriteOutBytesTest {
    private FileWriteOutBytes fileWriteOutBytes;
    private FileChannel mockFileChannel;

    @Before
    public void setUp() {
        this.mockFileChannel = (FileChannel)EasyMock.mock(FileChannel.class);
        this.fileWriteOutBytes = new FileWriteOutBytes((File)EasyMock.mock(File.class), this.mockFileChannel);
    }

    @Test
    public void write4KiBIntsShouldNotFlush() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            int remaining = buffer.remaining();
            buffer.position(remaining);
            return remaining;
        }).times(1);
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        int writeBytes = 4096;
        int numOfInt = 1024;
        for (int i = 0; i < 1024; ++i) {
            this.fileWriteOutBytes.writeInt(i);
        }
        this.fileWriteOutBytes.write(1);
        EasyMock.verify((Object[])new Object[]{this.mockFileChannel});
    }

    @Test
    public void writeShouldIncrementSize() throws IOException {
        this.fileWriteOutBytes.write(1);
        Assert.assertEquals((long)1L, (long)this.fileWriteOutBytes.size());
    }

    @Test
    public void writeIntShouldIncrementSize() throws IOException {
        this.fileWriteOutBytes.writeInt(1);
        Assert.assertEquals((long)4L, (long)this.fileWriteOutBytes.size());
    }

    @Test
    public void writeBufferLargerThanCapacityShouldIncrementSizeCorrectly() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            int remaining = buffer.remaining();
            buffer.position(remaining);
            return remaining;
        }).times(1);
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        ByteBuffer src = ByteBuffer.allocate(4097);
        this.fileWriteOutBytes.write(src);
        Assert.assertEquals((long)src.capacity(), (long)this.fileWriteOutBytes.size());
        EasyMock.verify((Object[])new Object[]{this.mockFileChannel});
    }

    @Test
    public void writeBufferLargerThanCapacityThrowsIOEInTheMiddleShouldIncrementSizeCorrectly() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            int remaining = buffer.remaining();
            buffer.position(remaining);
            return remaining;
        }).once();
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andThrow((Throwable)new IOException()).once();
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        ByteBuffer src = ByteBuffer.allocate(8193);
        try {
            this.fileWriteOutBytes.write(src);
            Assert.fail((String)"IOException should have been thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((long)8192L, (long)this.fileWriteOutBytes.size());
        }
    }

    @Test
    public void writeBufferSmallerThanCapacityShouldIncrementSizeCorrectly() throws IOException {
        ByteBuffer src = ByteBuffer.allocate(4096);
        this.fileWriteOutBytes.write(src);
        Assert.assertEquals((long)src.capacity(), (long)this.fileWriteOutBytes.size());
    }

    @Test
    public void sizeDoesNotFlush() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andThrow((Throwable)((Object)new AssertionError((Object)"file channel should not have been written to.")));
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        long size = this.fileWriteOutBytes.size();
        Assert.assertEquals((long)0L, (long)size);
        this.fileWriteOutBytes.writeInt(10);
        size = this.fileWriteOutBytes.size();
        Assert.assertEquals((long)4L, (long)size);
    }
}

