/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.MergeIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.AbstractPrioritizedQueryRunnerCallable;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.context.ResponseContext;

public class ChainedExecutionQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(ChainedExecutionQueryRunner.class);
    private final QueryProcessingPool queryProcessingPool;
    private final Iterable<QueryRunner<T>> queryables;
    private final QueryWatcher queryWatcher;

    public ChainedExecutionQueryRunner(QueryProcessingPool queryProcessingPool, QueryWatcher queryWatcher, Iterable<QueryRunner<T>> queryables) {
        this.queryProcessingPool = queryProcessingPool;
        this.queryables = Iterables.unmodifiableIterable(queryables);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final ResponseContext responseContext) {
        final Query<T> query = queryPlus.getQuery();
        final int priority = QueryContexts.getPriority(query);
        final Ordering<T> ordering = query.getResultOrdering();
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        return new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            public Iterator<T> make() {
                ArrayList futures = Lists.newArrayList((Iterable)Iterables.transform((Iterable)ChainedExecutionQueryRunner.this.queryables, input -> {
                    if (input == null) {
                        throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                    }
                    return ChainedExecutionQueryRunner.this.queryProcessingPool.submitRunnerTask(new AbstractPrioritizedQueryRunnerCallable<Iterable<T>, T>(priority, (QueryRunner)input, (QueryRunner)input, threadSafeQueryPlus, responseContext){
                        final /* synthetic */ QueryRunner val$input;
                        final /* synthetic */ QueryPlus val$threadSafeQueryPlus;
                        final /* synthetic */ ResponseContext val$responseContext;
                        {
                            this.val$input = queryRunner;
                            this.val$threadSafeQueryPlus = queryPlus;
                            this.val$responseContext = responseContext;
                            super(priority, runner);
                        }

                        @Override
                        public Iterable<T> call() {
                            try {
                                Sequence result = this.val$input.run(this.val$threadSafeQueryPlus, this.val$responseContext);
                                if (result == null) {
                                    throw new ISE("Got a null result! Segments are missing!", new Object[0]);
                                }
                                List retVal = result.toList();
                                if (retVal == null) {
                                    throw new ISE("Got a null list of results", new Object[0]);
                                }
                                return retVal;
                            }
                            catch (QueryInterruptedException e) {
                                throw new RuntimeException((Throwable)((Object)e));
                            }
                            catch (QueryTimeoutException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                log.noStackTrace().error((Throwable)e, "Exception with one of the sequences!", new Object[0]);
                                Throwables.propagateIfPossible((Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }));
                ListenableFuture future = Futures.allAsList((Iterable)futures);
                ChainedExecutionQueryRunner.this.queryWatcher.registerQueryFuture(query, future);
                try {
                    return new MergeIterable((Comparator)ordering.nullsFirst(), QueryContexts.hasTimeout(query) ? (Iterable)future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS) : (Iterable)future.get()).iterator();
                }
                catch (InterruptedException e) {
                    log.noStackTrace().warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
                    GuavaUtils.cancelAll((boolean)true, (Future)future, (List)futures);
                    throw new QueryInterruptedException(e);
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException(e);
                }
                catch (TimeoutException e) {
                    log.warn("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
                    GuavaUtils.cancelAll((boolean)true, (Future)future, (List)futures);
                    throw new QueryTimeoutException(StringUtils.nonStrictFormat((String)"Query [%s] timed out", (Object[])new Object[]{query.getId()}));
                }
                catch (ExecutionException e) {
                    GuavaUtils.cancelAll((boolean)true, (Future)future, (List)futures);
                    Throwables.propagateIfPossible((Throwable)e.getCause());
                    throw new RuntimeException(e.getCause());
                }
            }

            public void cleanup(Iterator<T> tIterator) {
            }
        });
    }
}

