/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.List;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.column.ValueType;

public class DruidMetrics {
    public static final String DATASOURCE = "dataSource";
    public static final String TYPE = "type";
    public static final String INTERVAL = "interval";
    public static final String ID = "id";
    public static final String TASK_ID = "taskId";
    public static final String STATUS = "status";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_STATUS = "taskStatus";
    public static final String SERVER = "server";
    public static final String TIER = "tier";
    public static final String DUTY = "duty";
    public static final String DUTY_GROUP = "dutyGroup";

    public static int findNumComplexAggs(List<AggregatorFactory> aggs) {
        int retVal = 0;
        for (AggregatorFactory agg : aggs) {
            if (!ValueType.COMPLEX.equals((Object)agg.getType())) continue;
            ++retVal;
        }
        return retVal;
    }

    public static <T> QueryMetrics<?> makeRequestMetrics(GenericQueryMetricsFactory queryMetricsFactory, QueryToolChest<T, Query<T>> toolChest, Query<T> query, String remoteAddr) {
        QueryMetrics<Query<Object>> queryMetrics = toolChest != null ? toolChest.makeMetrics(query) : queryMetricsFactory.makeMetrics(query);
        queryMetrics.remoteAddress(remoteAddr);
        return queryMetrics;
    }
}

