/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class InlineDataSource
implements DataSource {
    private final Iterable<Object[]> rows;
    private final RowSignature signature;

    private InlineDataSource(Iterable<Object[]> rows, RowSignature signature) {
        this.rows = (Iterable)Preconditions.checkNotNull(rows, (Object)"'rows' must be nonnull");
        this.signature = (RowSignature)Preconditions.checkNotNull((Object)signature, (Object)"'signature' must be nonnull");
    }

    @JsonCreator
    private static InlineDataSource fromJson(@JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<ValueType> columnTypes, @JsonProperty(value="rows") List<Object[]> rows) {
        Preconditions.checkNotNull(columnNames, (Object)"'columnNames' must be nonnull");
        if (columnTypes != null && columnNames.size() != columnTypes.size()) {
            throw new IAE("columnNames and columnTypes must be the same length", new Object[0]);
        }
        RowSignature.Builder builder = RowSignature.builder();
        for (int i = 0; i < columnNames.size(); ++i) {
            String name = columnNames.get(i);
            ValueType type = columnTypes != null ? columnTypes.get(i) : null;
            builder.add(name, type);
        }
        return new InlineDataSource(rows, builder.build());
    }

    public static InlineDataSource fromIterable(Iterable<Object[]> rows, RowSignature signature) {
        return new InlineDataSource(rows, signature);
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.signature.getColumnNames();
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ValueType> getColumnTypes() {
        if (IntStream.range(0, this.signature.size()).noneMatch(i -> this.signature.getColumnType(i).isPresent())) {
            return null;
        }
        return IntStream.range(0, this.signature.size()).mapToObj(i -> this.signature.getColumnType(i).orElse(null)).collect(Collectors.toList());
    }

    @JsonProperty(value="rows")
    public List<Object[]> getRowsAsList() {
        return this.rows instanceof List ? (List)this.rows : Lists.newArrayList(this.rows);
    }

    @JsonIgnore
    public Iterable<Object[]> getRows() {
        return this.rows;
    }

    @Override
    public List<DataSource> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (!children.isEmpty()) {
            throw new IAE("Cannot accept children", new Object[0]);
        }
        return this;
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    public RowSignature getRowSignature() {
        return this.signature;
    }

    public RowAdapter<Object[]> rowAdapter() {
        return new RowAdapter<Object[]>(){

            @Override
            public ToLongFunction<Object[]> timestampFunction() {
                int columnNumber = InlineDataSource.this.signature.indexOf("__time");
                if (columnNumber >= 0) {
                    return row -> (Long)row[columnNumber];
                }
                return row -> 0L;
            }

            @Override
            public Function<Object[], Object> columnFunction(String columnName) {
                int columnNumber = InlineDataSource.this.signature.indexOf(columnName);
                if (columnNumber >= 0) {
                    return row -> row[columnNumber];
                }
                return row -> null;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineDataSource that = (InlineDataSource)o;
        return InlineDataSource.rowsEqual(this.rows, that.rows) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(InlineDataSource.rowsHashCode(this.rows), this.signature);
    }

    public String toString() {
        return "InlineDataSource{signature=" + this.signature + '}';
    }

    private static boolean rowsEqual(Iterable<Object[]> rowsA, Iterable<Object[]> rowsB) {
        if (rowsA instanceof List && rowsB instanceof List) {
            List listA = (List)rowsA;
            List listB = (List)rowsB;
            if (listA.size() != listB.size()) {
                return false;
            }
            for (int i = 0; i < listA.size(); ++i) {
                Object[] rowB;
                Object[] rowA = (Object[])listA.get(i);
                if (Arrays.equals(rowA, rowB = (Object[])listB.get(i))) continue;
                return false;
            }
            return true;
        }
        return Objects.equals(rowsA, rowsB);
    }

    private static int rowsHashCode(Iterable<Object[]> rows) {
        if (rows instanceof List) {
            List list = (List)rows;
            int code = 1;
            for (Object[] row : list) {
                code = 31 * code + Arrays.hashCode(row);
            }
            return code;
        }
        return Objects.hash(rows);
    }
}

