/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.TruncatedResponseContextException;

public class QueryInterruptedException
extends QueryException {
    public static final String QUERY_INTERRUPTED = "Query interrupted";
    public static final String QUERY_CANCELLED = "Query cancelled";
    public static final String UNAUTHORIZED = "Unauthorized request";
    public static final String UNSUPPORTED_OPERATION = "Unsupported operation";
    public static final String TRUNCATED_RESPONSE_CONTEXT = "Truncated response context";
    public static final String UNKNOWN_EXCEPTION = "Unknown exception";

    @JsonCreator
    public QueryInterruptedException(@JsonProperty(value="error") @Nullable String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") @Nullable String errorClass, @JsonProperty(value="host") @Nullable String host) {
        super(errorCode, errorMessage, errorClass, host);
    }

    public QueryInterruptedException(Throwable cause) {
        this(cause, QueryInterruptedException.getHostFromThrowable(cause));
    }

    public QueryInterruptedException(Throwable cause, String host) {
        super(cause, QueryInterruptedException.getErrorCodeFromThrowable(cause), QueryInterruptedException.getErrorClassFromThrowable(cause), host);
    }

    public String toString() {
        return StringUtils.format((String)"QueryInterruptedException{msg=%s, code=%s, class=%s, host=%s}", (Object[])new Object[]{this.getMessage(), this.getErrorCode(), this.getErrorClass(), this.getHost()});
    }

    private static String getErrorCodeFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)((Object)e)).getErrorCode();
        }
        if (e instanceof InterruptedException) {
            return QUERY_INTERRUPTED;
        }
        if (e instanceof CancellationException) {
            return QUERY_CANCELLED;
        }
        if (e instanceof UnsupportedOperationException) {
            return UNSUPPORTED_OPERATION;
        }
        if (e instanceof TruncatedResponseContextException) {
            return TRUNCATED_RESPONSE_CONTEXT;
        }
        return UNKNOWN_EXCEPTION;
    }

    @Nullable
    private static String getErrorClassFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)((Object)e)).getErrorClass();
        }
        if (e != null) {
            return e.getClass().getName();
        }
        return null;
    }

    @Nullable
    private static String getHostFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)((Object)e)).getHost();
        }
        return null;
    }

    public static QueryInterruptedException wrapIfNeeded(Throwable e) {
        return e instanceof QueryInterruptedException ? (QueryInterruptedException)((Object)e) : new QueryInterruptedException(e);
    }
}

