/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.DataSourceAnalysis;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public UnionQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        Query<T> query = queryPlus.getQuery();
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource(query.getDataSource());
        if (analysis.isConcreteTableBased() && analysis.getBaseUnionDataSource().isPresent()) {
            UnionDataSource unionDataSource = analysis.getBaseUnionDataSource().get();
            if (unionDataSource.getDataSources().isEmpty()) {
                throw new ISE("Unexpectedly received empty union", new Object[0]);
            }
            if (unionDataSource.getDataSources().size() == 1) {
                return this.baseRunner.run(queryPlus.withQuery(Queries.withBaseDataSource(query, (DataSource)Iterables.getOnlyElement(unionDataSource.getDataSources()))), responseContext);
            }
            return new MergeSequence(query.getResultOrdering(), Sequences.simple((Iterable)Lists.transform(unionDataSource.getDataSources(), singleSource -> this.baseRunner.run(queryPlus.withQuery(Queries.withBaseDataSource(query, singleSource).withDefaultSubQueryId()), responseContext))));
        }
        return this.baseRunner.run(queryPlus, responseContext);
    }
}

