/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorInputBindings;

public class ExpressionLambdaAggregator
implements Aggregator {
    private final Expr lambda;
    private final ExpressionLambdaAggregatorInputBindings bindings;
    private final int maxSizeBytes;
    private boolean hasValue;

    public ExpressionLambdaAggregator(Expr lambda, ExpressionLambdaAggregatorInputBindings bindings, boolean isNullUnlessAggregated, int maxSizeBytes) {
        this.lambda = lambda;
        this.bindings = bindings;
        this.maxSizeBytes = maxSizeBytes;
        this.hasValue = !isNullUnlessAggregated;
    }

    @Override
    public void aggregate() {
        ExprEval eval = this.lambda.eval((Expr.ObjectBinding)this.bindings);
        ExprEval.estimateAndCheckMaxBytes((ExprEval)eval, (int)this.maxSizeBytes);
        this.bindings.accumulate(eval);
        this.hasValue = true;
    }

    @Override
    @Nullable
    public Object get() {
        return this.hasValue ? this.bindings.getAccumulator().value() : null;
    }

    @Override
    public float getFloat() {
        return (float)this.bindings.getAccumulator().asDouble();
    }

    @Override
    public long getLong() {
        return this.bindings.getAccumulator().asLong();
    }

    @Override
    public double getDouble() {
        return this.bindings.getAccumulator().asDouble();
    }

    @Override
    public boolean isNull() {
        return this.bindings.getAccumulator().isNumericNull();
    }

    @Override
    public void close() {
    }
}

