/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleMaxAggregateCombiner;
import org.apache.druid.query.aggregation.FloatMaxAggregator;
import org.apache.druid.query.aggregation.FloatMaxBufferAggregator;
import org.apache.druid.query.aggregation.FloatMaxVectorAggregator;
import org.apache.druid.query.aggregation.SimpleFloatAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatMaxAggregatorFactory
extends SimpleFloatAggregatorFactory {
    private final Supplier<byte[]> cacheKey;

    @JsonCreator
    public FloatMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") @Nullable String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
        this.cacheKey = AggregatorUtil.getSimpleAggregatorCacheKeySupplier((byte)13, fieldName, (Supplier<Expr>)this.fieldExpression);
    }

    public FloatMaxAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    protected float nullValue() {
        return Float.NEGATIVE_INFINITY;
    }

    @Override
    protected Aggregator buildAggregator(BaseFloatColumnValueSelector selector) {
        return new FloatMaxAggregator(selector);
    }

    @Override
    protected BufferAggregator buildBufferAggregator(BaseFloatColumnValueSelector selector) {
        return new FloatMaxBufferAggregator(selector);
    }

    @Override
    protected VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, VectorValueSelector selector) {
        return new FloatMaxVectorAggregator(selector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return FloatMaxAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleMaxAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatMaxAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new FloatMaxAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    public byte[] getCacheKey() {
        return (byte[])this.cacheKey.get();
    }

    public String toString() {
        return "FloatMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

