/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.expression.ExprUtils;

class ContainsExpr
extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
    private final Function<String, Boolean> searchFunction;
    private final Expr searchStrExpr;

    ContainsExpr(String functioName, Expr arg, Expr searchStrExpr, boolean caseSensitive) {
        super(functioName, arg);
        this.searchStrExpr = this.validateSearchExpr(searchStrExpr, functioName);
        this.searchFunction = this.createFunction(searchStrExpr, caseSensitive);
    }

    private ContainsExpr(String functioName, Expr arg, Expr searchStrExpr, Function<String, Boolean> searchFunction) {
        super(functioName, arg);
        this.searchFunction = searchFunction;
        this.searchStrExpr = this.validateSearchExpr(searchStrExpr, functioName);
    }

    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        String s = NullHandling.nullToEmptyIfNeeded((String)this.arg.eval(bindings).asString());
        if (s == null) {
            return ExprEval.ofLongBoolean((boolean)false);
        }
        boolean doesContain = this.searchFunction.apply(s);
        return ExprEval.ofLongBoolean((boolean)doesContain);
    }

    @Nullable
    public ExprType getOutputType(Expr.InputBindingInspector inspector) {
        return ExprType.LONG;
    }

    public Expr visit(Expr.Shuttle shuttle) {
        Expr newArg = this.arg.visit(shuttle);
        return shuttle.visit((Expr)new ContainsExpr(this.name, newArg, this.searchStrExpr, this.searchFunction));
    }

    public String stringify() {
        return org.apache.druid.java.util.common.StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{this.name, this.arg.stringify(), this.searchStrExpr.stringify()});
    }

    private Function<String, Boolean> createFunction(Expr searchStrExpr, boolean caseSensitive) {
        String searchStr = org.apache.druid.java.util.common.StringUtils.nullToEmptyNonDruidDataString((String)((String)searchStrExpr.getLiteralValue()));
        if (caseSensitive) {
            return s -> s.contains(searchStr);
        }
        return s -> StringUtils.containsIgnoreCase((String)s, (String)searchStr);
    }

    private Expr validateSearchExpr(Expr searchExpr, String functioName) {
        if (!ExprUtils.isStringLiteral(searchExpr)) {
            throw new IAE("Function[%s] substring must be a string literal", new Object[]{functioName});
        }
        return searchExpr;
    }
}

