/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongOutLongInFunctionVectorProcessor;
import org.apache.druid.query.expression.ExprUtils;

public class TimestampFloorExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_floor";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", new Object[]{this.name()});
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampFloorExpr(args);
        }
        return new TimestampFloorDynamicExpr(args);
    }

    private static PeriodGranularity computeGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    public static class TimestampFloorDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampFloorDynamicExpr(List<Expr> args) {
            super(TimestampFloorExprMacro.FN_NAME, args);
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampFloorExprMacro.computeGranularity(this.args, bindings);
            return ExprEval.of((long)granularity.bucketStart(((Expr)this.args.get(0)).eval(bindings).asLong()));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit((Expr)new TimestampFloorDynamicExpr(newArgs));
        }

        @Nullable
        public ExprType getOutputType(Expr.InputBindingInspector inspector) {
            return ExprType.LONG;
        }
    }

    public static class TimestampFloorExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final PeriodGranularity granularity;

        TimestampFloorExpr(List<Expr> args) {
            super(TimestampFloorExprMacro.FN_NAME, args);
            this.granularity = TimestampFloorExprMacro.computeGranularity(args, ExprUtils.nilBindings());
        }

        public Expr getArg() {
            return (Expr)this.args.get(0);
        }

        public PeriodGranularity getGranularity() {
            return this.granularity;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            return ExprEval.of((long)this.granularity.bucketStart(eval.asLong()));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit((Expr)new TimestampFloorExpr(newArgs));
        }

        @Nullable
        public ExprType getOutputType(Expr.InputBindingInspector inspector) {
            return ExprType.LONG;
        }

        public boolean canVectorize(Expr.InputBindingInspector inspector) {
            return ((Expr)this.args.get(0)).canVectorize(inspector);
        }

        public <T> ExprVectorProcessor<T> buildVectorized(Expr.VectorInputBindingInspector inspector) {
            LongOutLongInFunctionVectorProcessor processor = new LongOutLongInFunctionVectorProcessor(CastToTypeVectorProcessor.cast((ExprVectorProcessor)((Expr)this.args.get(0)).buildVectorized(inspector), (ExprType)ExprType.LONG), inspector.getMaxVectorSize()){

                public long apply(long input) {
                    return granularity.bucketStart(input);
                }
            };
            return processor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TimestampFloorExpr that = (TimestampFloorExpr)((Object)o);
            return Objects.equals(this.granularity, that.granularity);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.granularity);
        }
    }
}

