/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class DictionaryBuildingSingleValueStringGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private static final int GROUP_BY_MISSING_VALUE = -1;
    private final VectorObjectSelector selector;
    private int nextId = 0;
    private final List<String> dictionary = new ArrayList<String>();
    private final Object2IntOpenHashMap<String> reverseDictionary = new Object2IntOpenHashMap();

    public DictionaryBuildingSingleValueStringGroupByVectorColumnSelector(VectorObjectSelector selector) {
        this.reverseDictionary.defaultReturnValue(-1);
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        Object[] vector = this.selector.getObjectVector();
        int i = startRow;
        int j = keyOffset;
        while (i < endRow) {
            String value = (String)vector[i];
            int dictId = this.reverseDictionary.getInt((Object)value);
            if (dictId < 0) {
                this.dictionary.add(value);
                this.reverseDictionary.put((Object)value, this.nextId);
                keySpace.putInt((long)j, this.nextId);
                ++this.nextId;
            } else {
                keySpace.putInt((long)j, dictId);
            }
            ++i;
            j += keySize;
        }
    }

    @Override
    public void writeKeyToResultRow(Memory keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        int id = keyMemory.getInt((long)keyOffset);
        if (id != -1) {
            String value = this.dictionary.get(id);
            resultRow.set(resultRowPosition, value);
        } else {
            resultRow.set(resultRowPosition, NullHandling.defaultStringValue());
        }
    }
}

