/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.List;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryExecutor;
import org.apache.druid.query.search.SearchQueryRunner;
import org.apache.druid.query.search.SearchStrategy;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class CursorOnlyStrategy
extends SearchStrategy {
    public static final String NAME = "cursorOnly";

    public static CursorOnlyStrategy of(SearchQuery query) {
        return new CursorOnlyStrategy(query);
    }

    private CursorOnlyStrategy(SearchQuery query) {
        super(query);
    }

    @Override
    public List<SearchQueryExecutor> getExecutionPlan(SearchQuery query, Segment segment) {
        StorageAdapter adapter = segment.asStorageAdapter();
        List<DimensionSpec> dimensionSpecs = CursorOnlyStrategy.getDimsToSearch(adapter.getAvailableDimensions(), query.getDimensions());
        return ImmutableList.of((Object)new CursorBasedExecutor(query, segment, this.filter, this.interval, dimensionSpecs));
    }

    public static class CursorBasedExecutor
    extends SearchQueryExecutor {
        protected Filter filter;
        protected Interval interval;

        public CursorBasedExecutor(SearchQuery query, Segment segment, Filter filter, Interval interval, List<DimensionSpec> dimensionSpecs) {
            super(query, segment, dimensionSpecs);
            this.filter = filter;
            this.interval = interval;
        }

        @Override
        public Object2IntRBTreeMap<SearchHit> execute(int limit) {
            StorageAdapter adapter = this.segment.asStorageAdapter();
            Sequence<Cursor> cursors = adapter.makeCursors(this.filter, this.interval, VirtualColumns.EMPTY, this.query.getGranularity(), this.query.isDescending(), null);
            Object2IntRBTreeMap retVal = new Object2IntRBTreeMap(this.query.getSort().getComparator());
            retVal.defaultReturnValue(0);
            cursors.accumulate((Object)retVal, (map, cursor) -> {
                if (map.size() >= limit) {
                    return map;
                }
                ColumnSelectorPlus<SearchQueryRunner.SearchColumnSelectorStrategy>[] selectorPlusList = DimensionHandlerUtils.createColumnSelectorPluses(SearchQueryRunner.SEARCH_COLUMN_SELECTOR_STRATEGY_FACTORY, this.dimsToSearch, cursor.getColumnSelectorFactory());
                while (!cursor.isDone()) {
                    for (ColumnSelectorPlus<SearchQueryRunner.SearchColumnSelectorStrategy> selectorPlus : selectorPlusList) {
                        selectorPlus.getColumnSelectorStrategy().updateSearchResultSet(selectorPlus.getOutputName(), selectorPlus.getSelector(), this.searchQuerySpec, limit, (Object2IntRBTreeMap<SearchHit>)map);
                        if (map.size() < limit) continue;
                        return map;
                    }
                    cursor.advance();
                }
                return map;
            });
            return retVal;
        }
    }
}

