/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.StringDimensionIndexer;
import org.apache.druid.segment.StringDimensionMergerV9;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableDimensionValueSelector;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class StringDimensionHandler
implements DimensionHandler<Integer, int[], String> {
    private static final Comparator<ColumnValueSelector> DIMENSION_SELECTOR_COMPARATOR = (s1, s2) -> {
        IndexedInts row1 = StringDimensionHandler.getRow(s1);
        IndexedInts row2 = StringDimensionHandler.getRow(s2);
        int len1 = row1.size();
        int len2 = row2.size();
        int lenCompareResult = Integer.compare(len1, len2);
        if (lenCompareResult != 0 && len1 + len2 == 1) {
            IndexedInts longerRow;
            IndexedInts indexedInts = longerRow = len2 > len1 ? row2 : row1;
            if (longerRow.get(0) == 0) {
                return 0;
            }
            return longerRow == row1 ? 1 : -1;
        }
        int lenToCompare = Math.min(len1, len2);
        for (int valsIndex = 0; valsIndex < lenToCompare; ++valsIndex) {
            int v2;
            int v1 = row1.get(valsIndex);
            int valueCompareResult = Integer.compare(v1, v2 = row2.get(valsIndex));
            if (valueCompareResult == 0) continue;
            return valueCompareResult;
        }
        return lenCompareResult;
    };
    private final String dimensionName;
    private final DimensionSchema.MultiValueHandling multiValueHandling;
    private final boolean hasBitmapIndexes;
    private final boolean hasSpatialIndexes;

    private static IndexedInts getRow(ColumnValueSelector s) {
        if (s instanceof DimensionSelector) {
            return ((DimensionSelector)s).getRow();
        }
        if (s instanceof NilColumnValueSelector) {
            return ZeroIndexedInts.instance();
        }
        throw new ISE("ColumnValueSelector[%s], only DimensionSelector or NilColumnValueSelector is supported", new Object[]{s.getClass()});
    }

    public StringDimensionHandler(String dimensionName, DimensionSchema.MultiValueHandling multiValueHandling, boolean hasBitmapIndexes, boolean hasSpatialIndexes) {
        this.dimensionName = dimensionName;
        this.multiValueHandling = multiValueHandling;
        this.hasBitmapIndexes = hasBitmapIndexes;
        this.hasSpatialIndexes = hasSpatialIndexes;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionSchema.MultiValueHandling getMultivalueHandling() {
        return this.multiValueHandling;
    }

    @Override
    public int getLengthOfEncodedKeyComponent(int[] dimVals) {
        return dimVals.length;
    }

    @Override
    public Comparator<ColumnValueSelector> getEncodedValueSelectorComparator() {
        return DIMENSION_SELECTOR_COMPARATOR;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableEncodedValueSelector() {
        return new SettableDimensionValueSelector();
    }

    @Override
    public DimensionIndexer<Integer, int[], String> makeIndexer() {
        return new StringDimensionIndexer(this.multiValueHandling, this.hasBitmapIndexes, this.hasSpatialIndexes);
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        if (this.hasBitmapIndexes != capabilities.hasBitmapIndexes()) {
            throw new ISE("capabilities.hasBitmapIndexes[%s] != this.hasBitmapIndexes[%s]", new Object[]{capabilities.hasBitmapIndexes(), this.hasBitmapIndexes});
        }
        return new StringDimensionMergerV9(this.dimensionName, indexSpec, segmentWriteOutMedium, capabilities, progress, closer);
    }
}

