/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public interface VectorColumnProcessorFactory<T> {
    public T makeSingleValueDimensionProcessor(ColumnCapabilities var1, SingleValueDimensionVectorSelector var2);

    public T makeMultiValueDimensionProcessor(ColumnCapabilities var1, MultiValueDimensionVectorSelector var2);

    public T makeFloatProcessor(ColumnCapabilities var1, VectorValueSelector var2);

    public T makeDoubleProcessor(ColumnCapabilities var1, VectorValueSelector var2);

    public T makeLongProcessor(ColumnCapabilities var1, VectorValueSelector var2);

    public T makeObjectProcessor(ColumnCapabilities var1, VectorObjectSelector var2);

    default public boolean useDictionaryEncodedSelector(ColumnCapabilities capabilities) {
        Preconditions.checkArgument((capabilities != null ? 1 : 0) != 0, (Object)"Capabilities must not be null");
        Preconditions.checkArgument((capabilities.getType() == ValueType.STRING ? 1 : 0) != 0, (Object)"Must only be called on a STRING column");
        return capabilities.isDictionaryEncoded().and(capabilities.areDictionaryValuesUnique()).isTrue();
    }
}

