/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class SelectorFilter
implements Filter {
    private final String dimension;
    private final String value;
    @Nullable
    private final FilterTuning filterTuning;

    public SelectorFilter(String dimension, String value) {
        this(dimension, value, null);
    }

    public SelectorFilter(String dimension, String value, @Nullable FilterTuning filterTuning) {
        this.dimension = dimension;
        this.value = value;
        this.filterTuning = filterTuning;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.wrapDimensionValue(selector.getBitmapIndex(this.dimension, this.value));
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.value);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.value);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return (double)indexSelector.getBitmapIndex(this.dimension, this.value).size() / (double)indexSelector.getNumRows();
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", new Object[]{columnRewrites, this.dimension});
        }
        return new SelectorFilter(rewriteDimensionTo, this.value);
    }

    public String toString() {
        return StringUtils.format((String)"%s = %s", (Object[])new Object[]{this.dimension, this.value});
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorFilter that = (SelectorFilter)o;
        return Objects.equals(this.getDimension(), that.getDimension()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.getDimension(), this.getValue(), this.filterTuning);
    }
}

