/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;

public class JoinPrefixUtils {
    private static final Comparator<String> DESCENDING_LENGTH_STRING_COMPARATOR = (s1, s2) -> Integer.compare(s2.length(), s1.length());

    public static String validatePrefix(@Nullable String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IAE("Join clause cannot have null or empty prefix", new Object[0]);
        }
        if (JoinPrefixUtils.isPrefixedBy("__time", prefix) || "__time".equals(prefix)) {
            throw new IAE("Join clause cannot have prefix[%s], since it would shadow %s", new Object[]{prefix, "__time"});
        }
        return prefix;
    }

    public static boolean isPrefixedBy(String columnName, String prefix) {
        return columnName.length() > prefix.length() && columnName.startsWith(prefix);
    }

    public static void checkPrefixesForDuplicatesAndShadowing(List<String> prefixes) {
        prefixes.sort(DESCENDING_LENGTH_STRING_COMPARATOR);
        for (int i = 0; i < prefixes.size(); ++i) {
            String prefix = prefixes.get(i);
            for (int k = i + 1; k < prefixes.size(); ++k) {
                String otherPrefix = prefixes.get(k);
                if (prefix.equals(otherPrefix)) {
                    throw new IAE("Detected duplicate prefix in join clauses: [%s]", new Object[]{prefix});
                }
                if (!JoinPrefixUtils.isPrefixedBy(prefix, otherPrefix)) continue;
                throw new IAE("Detected conflicting prefixes in join clauses: [%s, %s]", new Object[]{prefix, otherPrefix});
            }
        }
    }
}

