/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.join.table.BroadcastSegmentIndexedTable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.timeline.DataSegment;

public class BroadcastJoinableMMappedQueryableSegmentizerFactory
implements SegmentizerFactory {
    private final IndexIO indexIO;
    private final Set<String> keyColumns;

    @JsonCreator
    public BroadcastJoinableMMappedQueryableSegmentizerFactory(@JacksonInject IndexIO indexIO, @JsonProperty(value="keyColumns") Set<String> keyColumns) {
        this.indexIO = indexIO;
        this.keyColumns = keyColumns;
    }

    @JsonProperty
    public Set<String> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public Segment factorize(final DataSegment dataSegment, File parentDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws SegmentLoadingException {
        try {
            return new QueryableIndexSegment(this.indexIO.loadIndex(parentDir, lazy, loadFailed), dataSegment.getId()){

                @Override
                @Nullable
                public <T> T as(Class<T> clazz) {
                    if (clazz.equals(IndexedTable.class)) {
                        return (T)new BroadcastSegmentIndexedTable(this, BroadcastJoinableMMappedQueryableSegmentizerFactory.this.keyColumns, dataSegment.getVersion());
                    }
                    return super.as(clazz);
                }
            };
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastJoinableMMappedQueryableSegmentizerFactory that = (BroadcastJoinableMMappedQueryableSegmentizerFactory)o;
        return Objects.equals(this.keyColumns, that.keyColumns);
    }

    public int hashCode() {
        return Objects.hash(this.keyColumns);
    }
}

